/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.json.parser.delegates.endvalue;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.event.json.parser.delegates.endvalue.JsonEndValueForge;
import com.espertech.esper.common.internal.event.json.parser.delegates.endvalue.JsonEndValueForgeUtil;
import com.espertech.esper.common.internal.event.json.parser.delegates.endvalue.JsonEndValueRefs;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;

public class JsonEndValueForgeZonedDateTime
implements JsonEndValueForge {
    public static final JsonEndValueForgeZonedDateTime INSTANCE = new JsonEndValueForgeZonedDateTime();

    private JsonEndValueForgeZonedDateTime() {
    }

    @Override
    public CodegenExpression captureValue(JsonEndValueRefs refs, CodegenMethod method, CodegenClassScope classScope) {
        return CodegenExpressionBuilder.staticMethod(JsonEndValueForgeZonedDateTime.class, "jsonToZonedDateTime", refs.getValueString(), refs.getName());
    }

    public static ZonedDateTime jsonToZonedDateTime(String value, String name) {
        return value == null ? null : JsonEndValueForgeZonedDateTime.jsonToZonedDateTimeNonNull(value, name);
    }

    public static ZonedDateTime jsonToZonedDateTimeNonNull(String stringValue, String name) {
        try {
            return ZonedDateTime.parse(stringValue);
        }
        catch (DateTimeParseException ex) {
            throw JsonEndValueForgeUtil.handleParseException(name, ZonedDateTime.class, stringValue, ex);
        }
    }
}

