/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.json.serde;

import com.espertech.esper.common.internal.util.CollectionUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class DIOJsonSerdeHelper {
    private static final byte NULL_TYPE = 0;
    private static final byte INT_TYPE = 1;
    private static final byte DOUBLE_TYPE = 2;
    private static final byte STRING_TYPE = 3;
    private static final byte BOOLEAN_TYPE = 4;
    private static final byte OBJECT_TYPE = 5;
    private static final byte ARRAY_TYPE = 6;

    static void write(Map<String, Object> object, DataOutput output) throws IOException {
        output.writeInt(object.size());
        for (Map.Entry<String, Object> entry : object.entrySet()) {
            output.writeUTF(entry.getKey());
            DIOJsonSerdeHelper.writeValue(entry.getValue(), output);
        }
    }

    public static Map<String, Object> read(DataInput input) throws IOException {
        int size = input.readInt();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(CollectionUtil.capacityHashMap(size));
        for (int i = 0; i < size; ++i) {
            String key = input.readUTF();
            Object value = DIOJsonSerdeHelper.readValue(input);
            map.put(key, value);
        }
        return map;
    }

    static void writeValue(Object value, DataOutput output) throws IOException {
        if (value == null) {
            output.write(0);
        } else if (value instanceof Integer) {
            output.write(1);
            output.writeInt((Integer)value);
        } else if (value instanceof Double) {
            output.write(2);
            output.writeDouble((Double)value);
        } else if (value instanceof String) {
            output.write(3);
            output.writeUTF((String)value);
        } else if (value instanceof Boolean) {
            output.write(4);
            output.writeBoolean((Boolean)value);
        } else if (value instanceof Map) {
            output.write(5);
            DIOJsonSerdeHelper.write((Map)value, output);
        } else if (value instanceof Object[]) {
            output.write(6);
            DIOJsonSerdeHelper.writeArray((Object[])value, output);
        } else {
            throw new IOException("Unrecognized json object type value of type " + value.getClass() + "'");
        }
    }

    static Object readValue(DataInput input) throws IOException {
        byte type = input.readByte();
        if (type == 0) {
            return null;
        }
        if (type == 1) {
            return input.readInt();
        }
        if (type == 2) {
            return input.readDouble();
        }
        if (type == 3) {
            return input.readUTF();
        }
        if (type == 4) {
            return input.readBoolean();
        }
        if (type == 5) {
            return DIOJsonSerdeHelper.read(input);
        }
        if (type == 6) {
            return DIOJsonSerdeHelper.readArray(input);
        }
        throw new IOException("Unrecognized json object type value of type " + type + "'");
    }

    static void writeArray(Object[] value, DataOutput output) throws IOException {
        output.writeInt(value.length);
        for (Object o : value) {
            DIOJsonSerdeHelper.writeValue(o, output);
        }
    }

    static Object[] readArray(DataInput input) throws IOException {
        int size = input.readInt();
        Object[] result = new Object[size];
        for (int i = 0; i < result.length; ++i) {
            result[i] = DIOJsonSerdeHelper.readValue(input);
        }
        return result;
    }
}

