/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.json.write;

import com.espertech.esper.common.client.json.minimaljson.JsonWriter;
import com.espertech.esper.common.internal.event.json.core.JsonEventObjectBase;
import com.espertech.esper.common.internal.event.json.parser.core.JsonDelegateFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonWriteUtil {
    private static final Logger log = LoggerFactory.getLogger(JsonEventObjectBase.class);

    public static void writeNullableString(JsonWriter writer, String value) throws IOException {
        if (value == null) {
            writer.writeLiteral("null");
        } else {
            writer.writeString(value);
        }
    }

    public static void writeNullableStringToString(JsonWriter writer, Object value) throws IOException {
        if (value == null) {
            writer.writeLiteral("null");
        } else {
            writer.writeString(value.toString());
        }
    }

    public static void writeNullableBoolean(JsonWriter writer, Boolean value) throws IOException {
        if (value == null) {
            writer.writeLiteral("null");
        } else {
            writer.writeLiteral(value != false ? "true" : "false");
        }
    }

    public static void writeNullableNumber(JsonWriter writer, Object value) throws IOException {
        if (value == null) {
            writer.writeLiteral("null");
        } else {
            writer.writeNumber(value.toString());
        }
    }

    public static void writeArray2DimString(JsonWriter writer, String[][] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (String[] strings : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            JsonWriteUtil.writeArrayString(writer, strings);
        }
        writer.writeArrayClose();
    }

    public static void writeArray2DimCharacter(JsonWriter writer, Character[][] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (Character[] characters : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            JsonWriteUtil.writeArrayCharacter(writer, characters);
        }
        writer.writeArrayClose();
    }

    public static void writeArray2DimLong(JsonWriter writer, Long[][] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (Long[] longs : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            JsonWriteUtil.writeArrayLong(writer, longs);
        }
        writer.writeArrayClose();
    }

    public static void writeArray2DimInteger(JsonWriter writer, Integer[][] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (Integer[] ints : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            JsonWriteUtil.writeArrayInteger(writer, ints);
        }
        writer.writeArrayClose();
    }

    public static void writeArray2DimAppClass(JsonWriter writer, Object[][] array, JsonDelegateFactory factory) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (Object[] values : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            JsonWriteUtil.writeArrayAppClass(writer, values, factory);
        }
        writer.writeArrayClose();
    }

    public static void writeArray2DimShort(JsonWriter writer, Short[][] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (Short[] shorts : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            JsonWriteUtil.writeArrayShort(writer, shorts);
        }
        writer.writeArrayClose();
    }

    public static void writeArray2DimDouble(JsonWriter writer, Double[][] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (Double[] doubles : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            JsonWriteUtil.writeArrayDouble(writer, doubles);
        }
        writer.writeArrayClose();
    }

    public static void writeArray2DimFloat(JsonWriter writer, Float[][] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (Float[] floats : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            JsonWriteUtil.writeArrayFloat(writer, floats);
        }
        writer.writeArrayClose();
    }

    public static void writeArray2DimByte(JsonWriter writer, Byte[][] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (Byte[] b : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            JsonWriteUtil.writeArrayByte(writer, b);
        }
        writer.writeArrayClose();
    }

    public static void writeArray2DimBoolean(JsonWriter writer, Boolean[][] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (Boolean[] bools : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            JsonWriteUtil.writeArrayBoolean(writer, bools);
        }
        writer.writeArrayClose();
    }

    public static void writeArray2DimBigInteger(JsonWriter writer, BigInteger[][] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (BigInteger[] b : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            JsonWriteUtil.writeArrayBigInteger(writer, b);
        }
        writer.writeArrayClose();
    }

    public static void writeArray2DimObjectToString(JsonWriter writer, Object[][] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (Object[] b : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            JsonWriteUtil.writeArrayObjectToString(writer, b);
        }
        writer.writeArrayClose();
    }

    public static void writeArray2DimBigDecimal(JsonWriter writer, BigDecimal[][] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (BigDecimal[] b : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            JsonWriteUtil.writeArrayBigDecimal(writer, b);
        }
        writer.writeArrayClose();
    }

    public static void writeArray2DimBooleanPrimitive(JsonWriter writer, boolean[][] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (boolean[] b : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            JsonWriteUtil.writeArrayBooleanPrimitive(writer, b);
        }
        writer.writeArrayClose();
    }

    public static void writeArray2DimBytePrimitive(JsonWriter writer, byte[][] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (byte[] bytes : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            JsonWriteUtil.writeArrayBytePrimitive(writer, bytes);
        }
        writer.writeArrayClose();
    }

    public static void writeArray2DimShortPrimitive(JsonWriter writer, short[][] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (short[] shorts : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            JsonWriteUtil.writeArrayShortPrimitive(writer, shorts);
        }
        writer.writeArrayClose();
    }

    public static void writeArray2DimIntPrimitive(JsonWriter writer, int[][] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (int[] ints : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            JsonWriteUtil.writeArrayIntPrimitive(writer, ints);
        }
        writer.writeArrayClose();
    }

    public static void writeArray2DimLongPrimitive(JsonWriter writer, long[][] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (long[] longs : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            JsonWriteUtil.writeArrayLongPrimitive(writer, longs);
        }
        writer.writeArrayClose();
    }

    public static void writeArray2DimFloatPrimitive(JsonWriter writer, float[][] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (float[] floats : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            JsonWriteUtil.writeArrayFloatPrimitive(writer, floats);
        }
        writer.writeArrayClose();
    }

    public static void writeArray2DimDoublePrimitive(JsonWriter writer, double[][] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (double[] doubles : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            JsonWriteUtil.writeArrayDoublePrimitive(writer, doubles);
        }
        writer.writeArrayClose();
    }

    public static void writeArray2DimCharPrimitive(JsonWriter writer, char[][] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (char[] chars : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            JsonWriteUtil.writeArrayCharPrimitive(writer, chars);
        }
        writer.writeArrayClose();
    }

    public static void writeArrayString(JsonWriter writer, String[] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (String string : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            JsonWriteUtil.writeNullableString(writer, string);
        }
        writer.writeArrayClose();
    }

    public static void writeCollectionString(JsonWriter writer, Collection<String> values) throws IOException {
        if (values == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (String string : values) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            JsonWriteUtil.writeNullableString(writer, string);
        }
        writer.writeArrayClose();
    }

    public static void writeCollectionAppClass(JsonWriter writer, Collection values, JsonDelegateFactory factory) throws IOException {
        if (values == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (Object value : values) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            if (value == null) {
                writer.writeLiteral("null");
                continue;
            }
            factory.write(writer, value);
        }
        writer.writeArrayClose();
    }

    public static void writeArrayAppClass(JsonWriter writer, Object[] values, JsonDelegateFactory factory) throws IOException {
        if (values == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (Object value : values) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            if (value == null) {
                writer.writeLiteral("null");
                continue;
            }
            factory.write(writer, value);
        }
        writer.writeArrayClose();
    }

    public static void writeArrayCharacter(JsonWriter writer, Character[] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (Character character : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            JsonWriteUtil.writeNullableStringToString(writer, character);
        }
        writer.writeArrayClose();
    }

    public static void writeArrayLong(JsonWriter writer, Long[] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (Long l : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            JsonWriteUtil.writeNullableNumber(writer, l);
        }
        writer.writeArrayClose();
    }

    public static void writeArrayInteger(JsonWriter writer, Integer[] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (Integer i : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            JsonWriteUtil.writeNullableNumber(writer, i);
        }
        writer.writeArrayClose();
    }

    public static void writeCollectionNumber(JsonWriter writer, Collection<Number> values) throws IOException {
        if (values == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (Number i : values) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            JsonWriteUtil.writeNullableNumber(writer, i);
        }
        writer.writeArrayClose();
    }

    public static void writeArrayShort(JsonWriter writer, Short[] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (Short s : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            JsonWriteUtil.writeNullableNumber(writer, s);
        }
        writer.writeArrayClose();
    }

    public static void writeArrayDouble(JsonWriter writer, Double[] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (Double d : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            JsonWriteUtil.writeNullableNumber(writer, d);
        }
        writer.writeArrayClose();
    }

    public static void writeArrayFloat(JsonWriter writer, Float[] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (Float f : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            JsonWriteUtil.writeNullableNumber(writer, f);
        }
        writer.writeArrayClose();
    }

    public static void writeArrayByte(JsonWriter writer, Byte[] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (Byte b : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            JsonWriteUtil.writeNullableNumber(writer, b);
        }
        writer.writeArrayClose();
    }

    public static void writeArrayBoolean(JsonWriter writer, Boolean[] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (Boolean b : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            JsonWriteUtil.writeNullableBoolean(writer, b);
        }
        writer.writeArrayClose();
    }

    public static void writeCollectionBoolean(JsonWriter writer, Collection<Boolean> values) throws IOException {
        if (values == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (Boolean b : values) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            JsonWriteUtil.writeNullableBoolean(writer, b);
        }
        writer.writeArrayClose();
    }

    public static void writeArrayBigInteger(JsonWriter writer, BigInteger[] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (BigInteger b : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            JsonWriteUtil.writeNullableNumber(writer, b);
        }
        writer.writeArrayClose();
    }

    public static void writeArrayBigDecimal(JsonWriter writer, BigDecimal[] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (BigDecimal b : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            JsonWriteUtil.writeNullableNumber(writer, b);
        }
        writer.writeArrayClose();
    }

    public static void writeArrayBooleanPrimitive(JsonWriter writer, boolean[] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (boolean b : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            writer.writeLiteral(b ? "true" : "false");
        }
        writer.writeArrayClose();
    }

    public static void writeArrayBytePrimitive(JsonWriter writer, byte[] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (byte b : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            writer.writeNumber(Byte.toString(b));
        }
        writer.writeArrayClose();
    }

    public static void writeArrayShortPrimitive(JsonWriter writer, short[] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (short s : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            writer.writeNumber(Short.toString(s));
        }
        writer.writeArrayClose();
    }

    public static void writeArrayIntPrimitive(JsonWriter writer, int[] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (int i : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            writer.writeNumber(Integer.toString(i));
        }
        writer.writeArrayClose();
    }

    public static void writeArrayLongPrimitive(JsonWriter writer, long[] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (long l : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            writer.writeNumber(Long.toString(l));
        }
        writer.writeArrayClose();
    }

    public static void writeArrayFloatPrimitive(JsonWriter writer, float[] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (float f : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            writer.writeNumber(Float.toString(f));
        }
        writer.writeArrayClose();
    }

    public static void writeArrayDoublePrimitive(JsonWriter writer, double[] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (double d : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            writer.writeNumber(Double.toString(d));
        }
        writer.writeArrayClose();
    }

    public static void writeArrayCharPrimitive(JsonWriter writer, char[] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (char c : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            writer.writeString(Character.toString(c));
        }
        writer.writeArrayClose();
    }

    public static void writeArrayObjectToString(JsonWriter writer, Object[] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (Object value : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            if (value == null) {
                writer.writeLiteral("null");
                continue;
            }
            writer.writeString(value.toString());
        }
        writer.writeArrayClose();
    }

    public static void writeEnumArray(JsonWriter writer, Object[] array) throws IOException {
        JsonWriteUtil.writeObjectArrayWToString(writer, array);
    }

    public static void writeEnumCollection(JsonWriter writer, Collection values) throws IOException {
        JsonWriteUtil.writeCollectionWToString(writer, values);
    }

    public static void writeEnumArray2Dim(JsonWriter writer, Object[][] array) throws IOException {
        JsonWriteUtil.writeObjectArray2DimWToString(writer, array);
    }

    public static void writeJsonValue(JsonWriter writer, String name, Object jsonValue) throws IOException {
        if (jsonValue == null) {
            writer.writeLiteral("null");
        } else if (jsonValue instanceof Boolean) {
            writer.writeLiteral((Boolean)jsonValue != false ? "true" : "false");
        } else if (jsonValue instanceof String) {
            writer.writeString((String)jsonValue);
        } else if (jsonValue instanceof Number) {
            writer.writeNumber(jsonValue.toString());
        } else if (jsonValue instanceof Object[]) {
            JsonWriteUtil.writeJsonArray(writer, name, (Object[])jsonValue);
        } else if (jsonValue instanceof Map) {
            JsonWriteUtil.writeJsonMap(writer, (Map)jsonValue);
        } else if (jsonValue instanceof JsonEventObjectBase) {
            writer.writeObjectOpen();
            JsonEventObjectBase und = (JsonEventObjectBase)jsonValue;
            und.write(writer);
            writer.writeObjectClose();
        } else {
            log.warn("Unknown json value of type " + jsonValue.getClass() + " encountered, skipping member '" + name + "'");
        }
    }

    public static void writeJsonMap(JsonWriter writer, Map<String, Object> map) throws IOException {
        if (map == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeObjectOpen();
        boolean first = true;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            writer.writeMemberName(entry.getKey());
            writer.writeMemberSeparator();
            JsonWriteUtil.writeJsonValue(writer, entry.getKey(), entry.getValue());
        }
        writer.writeObjectClose();
    }

    public static void writeJsonArray(JsonWriter writer, String name, Object[] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (Object item : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            JsonWriteUtil.writeJsonValue(writer, name, item);
        }
        writer.writeArrayClose();
    }

    public static void writeNested(JsonWriter writer, Object nested, JsonDelegateFactory nestedFactory) throws IOException {
        if (nested == null) {
            writer.writeLiteral("null");
            return;
        }
        nestedFactory.write(writer, nested);
    }

    public static void writeNested(JsonWriter writer, JsonEventObjectBase nested) throws IOException {
        if (nested == null) {
            writer.writeLiteral("null");
            return;
        }
        nested.write(writer);
    }

    public static void writeNestedArray(JsonWriter writer, Object[] nesteds, JsonDelegateFactory nestedFactory) throws IOException {
        if (nesteds == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (Object nested : nesteds) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            nestedFactory.write(writer, nested);
        }
        writer.writeArrayClose();
    }

    public static void writeNestedArray(JsonWriter writer, JsonEventObjectBase[] nesteds) throws IOException {
        if (nesteds == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (JsonEventObjectBase nested : nesteds) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            nested.write(writer);
        }
        writer.writeArrayClose();
    }

    private static void writeObjectArrayWToString(JsonWriter writer, Object[] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (Object object : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            if (object == null) {
                writer.writeLiteral("null");
                continue;
            }
            writer.writeString(object.toString());
        }
        writer.writeArrayClose();
    }

    public static void writeCollectionWToString(JsonWriter writer, Collection values) throws IOException {
        if (values == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (Object object : values) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            if (object == null) {
                writer.writeLiteral("null");
                continue;
            }
            writer.writeString(object.toString());
        }
        writer.writeArrayClose();
    }

    private static void writeObjectArray2DimWToString(JsonWriter writer, Object[][] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (Object[] objects : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            JsonWriteUtil.writeObjectArrayWToString(writer, objects);
        }
        writer.writeArrayClose();
    }
}

