/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.property;

import com.espertech.esper.common.internal.event.arr.ObjectArrayEventPropertyGetter;
import com.espertech.esper.common.internal.event.arr.ObjectArrayIndexedPropertyGetter;
import com.espertech.esper.common.internal.event.bean.core.BeanEventType;
import com.espertech.esper.common.internal.event.bean.getter.DynamicIndexedPropertyGetterByField;
import com.espertech.esper.common.internal.event.bean.getter.DynamicIndexedPropertyGetterByMethod;
import com.espertech.esper.common.internal.event.bean.service.BeanEventTypeFactory;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterSPI;
import com.espertech.esper.common.internal.event.map.MapEventPropertyGetter;
import com.espertech.esper.common.internal.event.map.MapIndexedPropertyGetter;
import com.espertech.esper.common.internal.event.property.DynamicProperty;
import com.espertech.esper.common.internal.event.property.GenericPropertyDesc;
import com.espertech.esper.common.internal.event.property.PropertyBase;
import com.espertech.esper.common.internal.event.property.PropertyWithIndex;
import com.espertech.esper.common.internal.event.xml.BaseXMLEventType;
import com.espertech.esper.common.internal.event.xml.DOMIndexedGetter;
import com.espertech.esper.common.internal.event.xml.SchemaElementComplex;
import com.espertech.esper.common.internal.event.xml.SchemaItem;
import java.io.StringWriter;
import java.util.Map;

public class DynamicIndexedProperty
extends PropertyBase
implements DynamicProperty,
PropertyWithIndex {
    private final int index;

    public DynamicIndexedProperty(String propertyName, int index) {
        super(propertyName);
        this.index = index;
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public String[] toPropertyArray() {
        return new String[]{this.getPropertyNameAtomic()};
    }

    @Override
    public EventPropertyGetterSPI getGetter(BeanEventType eventType, EventBeanTypedEventFactory eventBeanTypedEventFactory, BeanEventTypeFactory beanEventTypeFactory) {
        if (!eventType.getStem().isPublicFields()) {
            return new DynamicIndexedPropertyGetterByMethod(this.propertyNameAtomic, this.index, eventBeanTypedEventFactory, beanEventTypeFactory);
        }
        return new DynamicIndexedPropertyGetterByField(this.propertyNameAtomic, this.index, eventBeanTypedEventFactory, beanEventTypeFactory);
    }

    @Override
    public Class getPropertyType(BeanEventType eventType, BeanEventTypeFactory beanEventTypeFactory) {
        return Object.class;
    }

    @Override
    public GenericPropertyDesc getPropertyTypeGeneric(BeanEventType beanEventType, BeanEventTypeFactory beanEventTypeFactory) {
        return GenericPropertyDesc.getObjectGeneric();
    }

    @Override
    public Class getPropertyTypeMap(Map optionalMapPropTypes, BeanEventTypeFactory beanEventTypeFactory) {
        return Object.class;
    }

    @Override
    public MapEventPropertyGetter getGetterMap(Map optionalMapPropTypes, EventBeanTypedEventFactory eventBeanTypedEventFactory, BeanEventTypeFactory beanEventTypeFactory) {
        return new MapIndexedPropertyGetter(this.getPropertyNameAtomic(), this.index);
    }

    @Override
    public ObjectArrayEventPropertyGetter getGetterObjectArray(Map<String, Integer> indexPerProperty, Map<String, Object> nestableTypes, EventBeanTypedEventFactory eventBeanTypedEventFactory, BeanEventTypeFactory beanEventTypeFactory) {
        Integer propertyIndex = indexPerProperty.get(this.propertyNameAtomic);
        return propertyIndex == null ? null : new ObjectArrayIndexedPropertyGetter(propertyIndex, this.index);
    }

    @Override
    public void toPropertyEPL(StringWriter writer) {
        writer.append(this.propertyNameAtomic);
        writer.append('[');
        writer.append(Integer.toString(this.index));
        writer.append(']');
        writer.append('?');
    }

    @Override
    public EventPropertyGetterSPI getGetterDOM(SchemaElementComplex complexProperty, EventBeanTypedEventFactory eventBeanTypedEventFactory, BaseXMLEventType eventType, String propertyExpression) {
        return new DOMIndexedGetter(this.propertyNameAtomic, this.index, null);
    }

    @Override
    public SchemaItem getPropertyTypeSchema(SchemaElementComplex complexProperty) {
        return null;
    }

    @Override
    public EventPropertyGetterSPI getGetterDOM() {
        return new DOMIndexedGetter(this.propertyNameAtomic, this.index, null);
    }

    @Override
    public int getIndex() {
        return this.index;
    }
}

