/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.property;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.event.arr.ObjectArrayArrayPOJOEntryIndexedPropertyGetter;
import com.espertech.esper.common.internal.event.arr.ObjectArrayArrayPropertyGetter;
import com.espertech.esper.common.internal.event.arr.ObjectArrayEventPropertyGetterAndIndexed;
import com.espertech.esper.common.internal.event.arr.ObjectArrayEventType;
import com.espertech.esper.common.internal.event.bean.core.BeanEventType;
import com.espertech.esper.common.internal.event.bean.core.PropertyStem;
import com.espertech.esper.common.internal.event.bean.getter.ArrayFieldPropertyGetter;
import com.espertech.esper.common.internal.event.bean.getter.ArrayMethodPropertyGetter;
import com.espertech.esper.common.internal.event.bean.getter.IterableFieldPropertyGetter;
import com.espertech.esper.common.internal.event.bean.getter.IterableMethodPropertyGetter;
import com.espertech.esper.common.internal.event.bean.getter.KeyedMethodPropertyGetter;
import com.espertech.esper.common.internal.event.bean.getter.ListFieldPropertyGetter;
import com.espertech.esper.common.internal.event.bean.getter.ListMethodPropertyGetter;
import com.espertech.esper.common.internal.event.bean.service.BeanEventTypeFactory;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterAndIndexed;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterSPI;
import com.espertech.esper.common.internal.event.core.TypeBeanOrUnderlying;
import com.espertech.esper.common.internal.event.map.MapArrayPOJOEntryIndexedPropertyGetter;
import com.espertech.esper.common.internal.event.map.MapArrayPropertyGetter;
import com.espertech.esper.common.internal.event.map.MapEventPropertyGetterAndIndexed;
import com.espertech.esper.common.internal.event.map.MapEventType;
import com.espertech.esper.common.internal.event.property.GenericPropertyDesc;
import com.espertech.esper.common.internal.event.property.PropertyBase;
import com.espertech.esper.common.internal.event.property.PropertyWithIndex;
import com.espertech.esper.common.internal.event.xml.BaseXMLEventType;
import com.espertech.esper.common.internal.event.xml.DOMIndexedGetter;
import com.espertech.esper.common.internal.event.xml.FragmentFactoryDOMGetter;
import com.espertech.esper.common.internal.event.xml.SchemaElementComplex;
import com.espertech.esper.common.internal.event.xml.SchemaElementSimple;
import com.espertech.esper.common.internal.event.xml.SchemaItem;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;

public class IndexedProperty
extends PropertyBase
implements PropertyWithIndex {
    private int index;

    public IndexedProperty(String propertyName) {
        super(propertyName);
    }

    public IndexedProperty(String propertyName, int index) {
        super(propertyName);
        this.index = index;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public String[] toPropertyArray() {
        return new String[]{this.getPropertyNameAtomic()};
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public EventPropertyGetterAndIndexed getGetter(BeanEventType eventType, EventBeanTypedEventFactory eventBeanTypedEventFactory, BeanEventTypeFactory beanEventTypeFactory) {
        PropertyStem propertyDesc = eventType.getIndexedProperty(this.propertyNameAtomic);
        if (propertyDesc != null) {
            return new KeyedMethodPropertyGetter(propertyDesc.getReadMethod(), this.index, eventBeanTypedEventFactory, beanEventTypeFactory);
        }
        propertyDesc = eventType.getSimpleProperty(this.propertyNameAtomic);
        if (propertyDesc == null) {
            return null;
        }
        Class returnType = propertyDesc.getReturnType();
        if (returnType.isArray()) {
            if (propertyDesc.getReadMethod() != null) {
                Method method = propertyDesc.getReadMethod();
                return new ArrayMethodPropertyGetter(method, this.index, eventBeanTypedEventFactory, beanEventTypeFactory);
            }
            Field field = propertyDesc.getAccessorField();
            return new ArrayFieldPropertyGetter(field, this.index, eventBeanTypedEventFactory, beanEventTypeFactory);
        }
        if (JavaClassHelper.isImplementsInterface(returnType, List.class)) {
            if (propertyDesc.getReadMethod() != null) {
                Method method = propertyDesc.getReadMethod();
                return new ListMethodPropertyGetter(method, this.index, eventBeanTypedEventFactory, beanEventTypeFactory);
            }
            Field field = propertyDesc.getAccessorField();
            return new ListFieldPropertyGetter(field, this.index, eventBeanTypedEventFactory, beanEventTypeFactory);
        }
        if (JavaClassHelper.isImplementsInterface(returnType, Iterable.class)) {
            if (propertyDesc.getReadMethod() != null) {
                Method method = propertyDesc.getReadMethod();
                return new IterableMethodPropertyGetter(method, this.index, eventBeanTypedEventFactory, beanEventTypeFactory);
            }
            Field field = propertyDesc.getAccessorField();
            return new IterableFieldPropertyGetter(field, this.index, eventBeanTypedEventFactory, beanEventTypeFactory);
        }
        return null;
    }

    @Override
    public GenericPropertyDesc getPropertyTypeGeneric(BeanEventType eventType, BeanEventTypeFactory beanEventTypeFactory) {
        PropertyStem descriptor = eventType.getIndexedProperty(this.propertyNameAtomic);
        if (descriptor != null) {
            return new GenericPropertyDesc(descriptor.getReturnType());
        }
        descriptor = eventType.getSimpleProperty(this.propertyNameAtomic);
        if (descriptor == null) {
            return null;
        }
        Class returnType = descriptor.getReturnType();
        if (returnType.isArray()) {
            return new GenericPropertyDesc(returnType.getComponentType());
        }
        if (JavaClassHelper.isImplementsInterface(returnType, Iterable.class)) {
            if (descriptor.getReadMethod() != null) {
                Class genericType = JavaClassHelper.getGenericReturnType(descriptor.getReadMethod(), false);
                return new GenericPropertyDesc(genericType);
            }
            if (descriptor.getAccessorField() != null) {
                Class genericType = JavaClassHelper.getGenericFieldType(descriptor.getAccessorField(), false);
                return new GenericPropertyDesc(genericType);
            }
            return null;
        }
        return null;
    }

    @Override
    public Class getPropertyType(BeanEventType eventType, BeanEventTypeFactory beanEventTypeFactory) {
        PropertyStem descriptor = eventType.getIndexedProperty(this.propertyNameAtomic);
        if (descriptor != null) {
            return descriptor.getReturnType();
        }
        descriptor = eventType.getSimpleProperty(this.propertyNameAtomic);
        if (descriptor == null) {
            return null;
        }
        Class returnType = descriptor.getReturnType();
        if (returnType.isArray()) {
            return returnType.getComponentType();
        }
        if (JavaClassHelper.isImplementsInterface(returnType, Iterable.class)) {
            if (descriptor.getReadMethod() != null) {
                return JavaClassHelper.getGenericReturnType(descriptor.getReadMethod(), false);
            }
            if (descriptor.getAccessorField() != null) {
                return JavaClassHelper.getGenericFieldType(descriptor.getAccessorField(), false);
            }
            return null;
        }
        return null;
    }

    @Override
    public Class getPropertyTypeMap(Map optionalMapPropTypes, BeanEventTypeFactory beanEventTypeFactory) {
        Object type = optionalMapPropTypes.get(this.propertyNameAtomic);
        if (type == null) {
            return null;
        }
        if (type instanceof TypeBeanOrUnderlying[]) {
            EventType innerType = ((TypeBeanOrUnderlying[])type)[0].getEventType();
            if (!(innerType instanceof MapEventType)) {
                return null;
            }
            return Map[].class;
        }
        if (!(type instanceof Class)) {
            return null;
        }
        if (!((Class)type).isArray()) {
            return null;
        }
        return ((Class)type).getComponentType();
    }

    @Override
    public MapEventPropertyGetterAndIndexed getGetterMap(Map optionalMapPropTypes, EventBeanTypedEventFactory eventBeanTypedEventFactory, BeanEventTypeFactory beanEventTypeFactory) {
        Object type = optionalMapPropTypes.get(this.propertyNameAtomic);
        if (type == null) {
            return null;
        }
        if (type instanceof TypeBeanOrUnderlying[]) {
            EventType innerType = ((TypeBeanOrUnderlying[])type)[0].getEventType();
            if (!(innerType instanceof MapEventType)) {
                return null;
            }
            return new MapArrayPropertyGetter(this.propertyNameAtomic, this.index, eventBeanTypedEventFactory, innerType);
        }
        if (!(type instanceof Class)) {
            return null;
        }
        if (!((Class)type).isArray()) {
            return null;
        }
        Class<?> componentType = ((Class)type).getComponentType();
        return new MapArrayPOJOEntryIndexedPropertyGetter(this.propertyNameAtomic, this.index, eventBeanTypedEventFactory, beanEventTypeFactory, componentType);
    }

    @Override
    public void toPropertyEPL(StringWriter writer) {
        writer.append(this.propertyNameAtomic);
        writer.append("[");
        writer.append(Integer.toString(this.index));
        writer.append("]");
    }

    @Override
    public EventPropertyGetterSPI getGetterDOM() {
        return new DOMIndexedGetter(this.propertyNameAtomic, this.index, null);
    }

    @Override
    public EventPropertyGetterSPI getGetterDOM(SchemaElementComplex complexProperty, EventBeanTypedEventFactory eventBeanTypedEventFactory, BaseXMLEventType eventType, String propertyExpression) {
        for (SchemaElementSimple simple : complexProperty.getSimpleElements()) {
            if (!simple.isArray() || !simple.getName().equals(this.propertyNameAtomic)) continue;
            return new DOMIndexedGetter(this.propertyNameAtomic, this.index, null);
        }
        for (SchemaElementComplex complex : complexProperty.getChildren()) {
            if (!complex.isArray() || !complex.getName().equals(this.propertyNameAtomic)) continue;
            return new DOMIndexedGetter(this.propertyNameAtomic, this.index, new FragmentFactoryDOMGetter(eventBeanTypedEventFactory, eventType, propertyExpression));
        }
        return null;
    }

    @Override
    public SchemaItem getPropertyTypeSchema(SchemaElementComplex complexProperty) {
        for (SchemaElementSimple simple : complexProperty.getSimpleElements()) {
            if (!simple.isArray() || !simple.getName().equals(this.propertyNameAtomic)) continue;
            return new SchemaElementSimple(simple.getName(), simple.getNamespace(), simple.getXsSimpleType(), simple.getTypeName(), false, simple.getFractionDigits());
        }
        for (SchemaElementComplex complex : complexProperty.getChildren()) {
            if (!complex.isArray() || !complex.getName().equals(this.propertyNameAtomic)) continue;
            return new SchemaElementComplex(complex.getName(), complex.getNamespace(), complex.getAttributes(), complex.getChildren(), complex.getSimpleElements(), false, complex.getOptionalSimpleType(), complex.getOptionalSimpleTypeName());
        }
        return null;
    }

    public static Integer getIndex(String propertyName) {
        int start = propertyName.indexOf(91);
        int end = propertyName.indexOf(93);
        String indexStr = propertyName.substring(start, end);
        return Integer.parseInt(indexStr);
    }

    @Override
    public ObjectArrayEventPropertyGetterAndIndexed getGetterObjectArray(Map<String, Integer> indexPerProperty, Map<String, Object> nestableTypes, EventBeanTypedEventFactory eventBeanTypedEventFactory, BeanEventTypeFactory beanEventTypeFactory) {
        Integer propertyIndex = indexPerProperty.get(this.propertyNameAtomic);
        if (propertyIndex == null) {
            return null;
        }
        Object type = nestableTypes.get(this.getPropertyNameAtomic());
        if (type == null) {
            return null;
        }
        if (type instanceof TypeBeanOrUnderlying[]) {
            EventType innerType = ((TypeBeanOrUnderlying[])type)[0].getEventType();
            if (!(innerType instanceof ObjectArrayEventType)) {
                return null;
            }
            return new ObjectArrayArrayPropertyGetter(propertyIndex, this.index, eventBeanTypedEventFactory, innerType);
        }
        if (!(type instanceof Class)) {
            return null;
        }
        if (!((Class)type).isArray()) {
            return null;
        }
        Class<?> componentType = ((Class)type).getComponentType();
        return new ObjectArrayArrayPOJOEntryIndexedPropertyGetter(propertyIndex, this.index, eventBeanTypedEventFactory, beanEventTypeFactory, componentType);
    }
}

