/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.propertyparser;

import com.espertech.esper.common.internal.event.propertyparser.PropertyParseNodepException;
import com.espertech.esper.common.internal.event.propertyparser.Token;
import com.espertech.esper.common.internal.event.propertyparser.TokenInfo;
import com.espertech.esper.common.internal.event.propertyparser.TokenType;
import java.util.ArrayDeque;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Tokenizer {
    private final LinkedList<TokenInfo> tokenInfos = new LinkedList();

    public void add(String pattern, TokenType token) {
        this.tokenInfos.add(new TokenInfo(Pattern.compile("^(" + pattern + ")"), token));
    }

    public ArrayDeque<Token> tokenize(String str) throws PropertyParseNodepException {
        ArrayDeque<Token> tokens = new ArrayDeque<Token>(4);
        while (!str.equals("")) {
            boolean match = false;
            for (TokenInfo info : this.tokenInfos) {
                Matcher m = info.regex.matcher(str);
                if (!m.find()) continue;
                match = true;
                String tok = m.group().trim();
                tokens.add(new Token(info.token, tok));
                str = m.replaceFirst("").trim();
                break;
            }
            if (match) continue;
            throw new PropertyParseNodepException("Unexpected token '" + str + "'");
        }
        return tokens;
    }
}

