/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.render;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.render.EPRenderEventService;
import com.espertech.esper.common.client.render.JSONEventRenderer;
import com.espertech.esper.common.client.render.JSONEventRendererJsonEventType;
import com.espertech.esper.common.client.render.JSONRenderingOptions;
import com.espertech.esper.common.client.render.XMLEventRenderer;
import com.espertech.esper.common.client.render.XMLRenderingOptions;
import com.espertech.esper.common.internal.event.json.core.JsonEventType;
import com.espertech.esper.common.internal.event.render.JSONRendererImpl;
import com.espertech.esper.common.internal.event.render.XMLRendererImpl;

public class EPRenderEventServiceImpl
implements EPRenderEventService {
    @Override
    public JSONEventRenderer getJSONRenderer(EventType eventType, JSONRenderingOptions options) {
        if (eventType instanceof JsonEventType) {
            return JSONEventRendererJsonEventType.INSTANCE;
        }
        if (options == null) {
            options = new JSONRenderingOptions();
        }
        return new JSONRendererImpl(eventType, options);
    }

    @Override
    public JSONEventRenderer getJSONRenderer(EventType eventType) {
        return this.getJSONRenderer(eventType, null);
    }

    @Override
    public String renderJSON(String title, EventBean theEvent) {
        return this.renderJSON(title, theEvent, new JSONRenderingOptions());
    }

    @Override
    public String renderJSON(String title, EventBean theEvent, JSONRenderingOptions options) {
        if (theEvent == null) {
            return null;
        }
        return this.getJSONRenderer(theEvent.getEventType(), options).render(title, theEvent);
    }

    @Override
    public XMLEventRenderer getXMLRenderer(EventType eventType) {
        return new XMLRendererImpl(eventType, new XMLRenderingOptions());
    }

    @Override
    public XMLEventRenderer getXMLRenderer(EventType eventType, XMLRenderingOptions options) {
        return new XMLRendererImpl(eventType, options);
    }

    @Override
    public String renderXML(String rootElementName, EventBean theEvent) {
        return this.renderXML(rootElementName, theEvent, new XMLRenderingOptions());
    }

    @Override
    public String renderXML(String rootElementName, EventBean theEvent, XMLRenderingOptions options) {
        if (theEvent == null) {
            return null;
        }
        return this.getXMLRenderer(theEvent.getEventType(), options).render(rootElementName, theEvent);
    }
}

