/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.render;

import com.espertech.esper.common.client.EventPropertyDescriptor;
import com.espertech.esper.common.client.EventPropertyGetter;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.FragmentEventType;
import com.espertech.esper.common.internal.event.render.GetterPair;
import com.espertech.esper.common.internal.event.render.NestedGetterPair;
import com.espertech.esper.common.internal.event.render.OutputValueRendererFactory;
import com.espertech.esper.common.internal.event.render.RendererMetaOptions;
import com.espertech.esper.common.internal.event.util.EventTypePropertyPair;
import java.util.ArrayList;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RendererMeta {
    private static final Logger log = LoggerFactory.getLogger(RendererMeta.class);
    private final GetterPair[] simpleProperties;
    private final GetterPair[] indexProperties;
    private final GetterPair[] mappedProperties;
    private final NestedGetterPair[] nestedProperties;

    public RendererMeta(EventType eventType, Stack<EventTypePropertyPair> stack, RendererMetaOptions options) {
        EventPropertyDescriptor[] descriptors;
        ArrayList<GetterPair> gettersSimple = new ArrayList<GetterPair>();
        ArrayList<GetterPair> gettersIndexed = new ArrayList<GetterPair>();
        ArrayList<GetterPair> gettersMapped = new ArrayList<GetterPair>();
        ArrayList<NestedGetterPair> gettersNested = new ArrayList<NestedGetterPair>();
        for (EventPropertyDescriptor desc : descriptors = eventType.getPropertyDescriptors()) {
            EventPropertyGetter getter;
            String propertyName = desc.getPropertyName();
            if (!(desc.isIndexed() || desc.isMapped() || desc.isFragment())) {
                getter = eventType.getGetter(propertyName);
                if (getter == null) {
                    log.warn("No getter returned for event type '" + eventType.getName() + "' and property '" + propertyName + "'");
                    continue;
                }
                gettersSimple.add(new GetterPair(getter, propertyName, OutputValueRendererFactory.getOutputValueRenderer(desc.getPropertyType(), options)));
            }
            if (desc.isIndexed() && !desc.isRequiresIndex() && !desc.isFragment()) {
                getter = eventType.getGetter(propertyName);
                if (getter == null) {
                    log.warn("No getter returned for event type '" + eventType.getName() + "' and property '" + propertyName + "'");
                    continue;
                }
                gettersIndexed.add(new GetterPair(getter, propertyName, OutputValueRendererFactory.getOutputValueRenderer(desc.getPropertyType(), options)));
            }
            if (desc.isMapped() && !desc.isRequiresMapkey() && !desc.isFragment()) {
                getter = eventType.getGetter(propertyName);
                if (getter == null) {
                    log.warn("No getter returned for event type '" + eventType.getName() + "' and property '" + propertyName + "'");
                    continue;
                }
                gettersMapped.add(new GetterPair(getter, propertyName, OutputValueRendererFactory.getOutputValueRenderer(desc.getPropertyType(), options)));
            }
            if (!desc.isFragment()) continue;
            getter = eventType.getGetter(propertyName);
            FragmentEventType fragmentType = eventType.getFragmentType(propertyName);
            if (getter == null) {
                log.warn("No getter returned for event type '" + eventType.getName() + "' and property '" + propertyName + "'");
                continue;
            }
            if (fragmentType == null) {
                log.warn("No fragment type returned for event type '" + eventType.getName() + "' and property '" + propertyName + "'");
                continue;
            }
            EventTypePropertyPair pair = new EventTypePropertyPair(fragmentType.getFragmentType(), propertyName);
            if (options.isPreventLooping() && stack.contains(pair)) continue;
            stack.push(pair);
            RendererMeta fragmentMetaData = new RendererMeta(fragmentType.getFragmentType(), stack, options);
            stack.pop();
            gettersNested.add(new NestedGetterPair(getter, propertyName, fragmentMetaData, fragmentType.isIndexed()));
        }
        this.simpleProperties = gettersSimple.toArray(new GetterPair[gettersSimple.size()]);
        this.indexProperties = gettersIndexed.toArray(new GetterPair[gettersIndexed.size()]);
        this.mappedProperties = gettersMapped.toArray(new GetterPair[gettersMapped.size()]);
        this.nestedProperties = gettersNested.toArray(new NestedGetterPair[gettersNested.size()]);
    }

    public GetterPair[] getSimpleProperties() {
        return this.simpleProperties;
    }

    public GetterPair[] getIndexProperties() {
        return this.indexProperties;
    }

    public NestedGetterPair[] getNestedProperties() {
        return this.nestedProperties;
    }

    public GetterPair[] getMappedProperties() {
        return this.mappedProperties;
    }
}

