/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.xml;

import java.util.ArrayList;
import java.util.List;

public class ElementPathNode {
    private final String name;
    private final ElementPathNode parent;
    private List<ElementPathNode> children = null;

    public ElementPathNode(ElementPathNode parent, String name) {
        this.name = name;
        this.parent = parent;
    }

    public ElementPathNode addChild(String name) {
        if (this.children == null) {
            this.children = new ArrayList<ElementPathNode>();
        }
        ElementPathNode newChild = new ElementPathNode(this, name);
        this.children.add(newChild);
        return newChild;
    }

    public String getName() {
        return this.name;
    }

    public ElementPathNode getParent() {
        return this.parent;
    }

    public boolean doesNameAlreadyExistInHierarchy() {
        return this.doesNameAlreadyExistInHierarchy(this.getName());
    }

    private boolean doesNameAlreadyExistInHierarchy(String nameToFind) {
        boolean doesNameAlreadyExistInHierarchy = false;
        if (this.parent != null) {
            if (this.parent.getName().equals(nameToFind)) {
                doesNameAlreadyExistInHierarchy = true;
            } else {
                return this.parent.doesNameAlreadyExistInHierarchy(nameToFind);
            }
        }
        return doesNameAlreadyExistInHierarchy;
    }
}

