/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.xml;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventSender;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.util.EPRuntimeEventProcessWrapped;
import com.espertech.esper.common.internal.event.xml.BaseXMLEventType;
import com.espertech.esper.common.internal.statement.thread.ThreadingCommon;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EventSenderXMLDOM
implements EventSender {
    private final EPRuntimeEventProcessWrapped runtimeEventSender;
    private final BaseXMLEventType baseXMLEventType;
    private final boolean validateRootElement;
    private final EventBeanTypedEventFactory eventBeanTypedEventFactory;
    private final ThreadingCommon threadingService;

    public EventSenderXMLDOM(EPRuntimeEventProcessWrapped runtimeEventSender, BaseXMLEventType baseXMLEventType, EventBeanTypedEventFactory eventBeanTypedEventFactory, ThreadingCommon threadingService) {
        this.runtimeEventSender = runtimeEventSender;
        this.baseXMLEventType = baseXMLEventType;
        this.validateRootElement = baseXMLEventType.getConfigurationEventTypeXMLDOM().isEventSenderValidatesRoot();
        this.eventBeanTypedEventFactory = eventBeanTypedEventFactory;
        this.threadingService = threadingService;
    }

    @Override
    public void sendEvent(Object theEvent) throws EPException {
        this.sendEvent(theEvent, false);
    }

    @Override
    public void routeEvent(Object theEvent) throws EPException {
        this.sendEvent(theEvent, true);
    }

    private void sendEvent(Object node, boolean isRoute) throws EPException {
        Element namedNode;
        if (node instanceof Document) {
            namedNode = ((Document)node).getDocumentElement();
        } else if (node instanceof Element) {
            namedNode = (Element)node;
        } else {
            throw new EPException("Unexpected event object type '" + node.getClass().getName() + "' encountered, please supply a org.w3c.dom.Document or Element node");
        }
        if (this.validateRootElement) {
            String getNodeName = namedNode.getLocalName();
            if (getNodeName == null) {
                getNodeName = namedNode.getNodeName();
            }
            if (!getNodeName.equals(this.baseXMLEventType.getRootElementName())) {
                throw new EPException("Unexpected root element name '" + getNodeName + "' encountered, expected a root element name of '" + this.baseXMLEventType.getRootElementName() + "'");
            }
        }
        EventBean theEvent = this.eventBeanTypedEventFactory.adapterForTypedDOM(namedNode, this.baseXMLEventType);
        if (isRoute) {
            this.runtimeEventSender.routeEventBean(theEvent);
        } else if (this.threadingService.isInboundThreading()) {
            this.threadingService.submitInbound(theEvent, this.runtimeEventSender);
        } else {
            this.runtimeEventSender.processWrappedEvent(theEvent);
        }
    }
}

