/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.xml;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.FragmentEventType;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonEventTypeXMLDOM;
import com.espertech.esper.common.client.meta.EventTypeMetadata;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterSPI;
import com.espertech.esper.common.internal.event.core.EventTypeNameResolver;
import com.espertech.esper.common.internal.event.property.Property;
import com.espertech.esper.common.internal.event.property.PropertyParser;
import com.espertech.esper.common.internal.event.propertyparser.PropertyParserNoDep;
import com.espertech.esper.common.internal.event.xml.BaseXMLEventType;
import com.espertech.esper.common.internal.event.xml.DOMConvertingGetter;
import com.espertech.esper.common.internal.event.xml.DOMPropertyGetter;
import com.espertech.esper.common.internal.event.xml.SimpleXMLPropertyParser;
import com.espertech.esper.common.internal.event.xml.XMLFragmentEventTypeFactory;
import com.espertech.esper.common.internal.event.xml.XPathNamespaceContext;
import com.espertech.esper.common.internal.event.xml.XPathPropertyGetter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class SimpleXMLEventType
extends BaseXMLEventType {
    private static final Logger log = LoggerFactory.getLogger(SimpleXMLEventType.class);
    private final Map<String, EventPropertyGetterSPI> propertyGetterCache;
    private String defaultNamespacePrefix;
    private final boolean isResolvePropertiesAbsolute;

    public SimpleXMLEventType(EventTypeMetadata eventTypeMetadata, ConfigurationCommonEventTypeXMLDOM configurationEventTypeXMLDOM, EventBeanTypedEventFactory eventBeanTypedEventFactory, EventTypeNameResolver eventTypeResolver, XMLFragmentEventTypeFactory xmlEventTypeFactory) {
        super(eventTypeMetadata, configurationEventTypeXMLDOM, eventBeanTypedEventFactory, eventTypeResolver, xmlEventTypeFactory);
        this.isResolvePropertiesAbsolute = configurationEventTypeXMLDOM.isXPathResolvePropertiesAbsolute();
        this.propertyGetterCache = new HashMap<String, EventPropertyGetterSPI>();
        XPathNamespaceContext xPathNamespaceContext = new XPathNamespaceContext();
        for (Map.Entry<String, String> entry : configurationEventTypeXMLDOM.getNamespacePrefixes().entrySet()) {
            xPathNamespaceContext.addPrefix(entry.getKey(), entry.getValue());
        }
        if (configurationEventTypeXMLDOM.getDefaultNamespace() != null) {
            String defaultNamespace = configurationEventTypeXMLDOM.getDefaultNamespace();
            xPathNamespaceContext.setDefaultNamespace(defaultNamespace);
            this.defaultNamespacePrefix = null;
            for (Map.Entry<String, String> entry : configurationEventTypeXMLDOM.getNamespacePrefixes().entrySet()) {
                if (!entry.getValue().equals(defaultNamespace)) continue;
                this.defaultNamespacePrefix = entry.getKey();
                break;
            }
        }
        super.setNamespaceContext(xPathNamespaceContext);
        super.initialize(configurationEventTypeXMLDOM.getXPathProperties().values(), Collections.EMPTY_LIST);
    }

    @Override
    protected Class doResolvePropertyType(String propertyExpression) {
        return SimpleXMLEventType.resolveSimpleXMLPropertyType(propertyExpression);
    }

    @Override
    protected EventPropertyGetterSPI doResolvePropertyGetter(String propertyExpression) {
        EventPropertyGetterSPI getter = this.propertyGetterCache.get(propertyExpression);
        if (getter != null) {
            return getter;
        }
        getter = SimpleXMLEventType.resolveSimpleXMLPropertyGetter(propertyExpression, this, this.defaultNamespacePrefix, this.isResolvePropertiesAbsolute);
        this.propertyGetterCache.put(propertyExpression, getter);
        return getter;
    }

    @Override
    protected FragmentEventType doResolveFragmentType(String property) {
        return null;
    }

    public static Class resolveSimpleXMLPropertyType(String propertyExpression) {
        Property prop = PropertyParser.parseAndWalkLaxToSimple(propertyExpression);
        if (PropertyParser.isPropertyDynamic(prop)) {
            return Node.class;
        }
        return String.class;
    }

    public static EventPropertyGetterSPI resolveSimpleXMLPropertyGetter(String propertyExpression, BaseXMLEventType baseXMLEventType, String defaultNamespacePrefix, boolean isResolvePropertiesAbsolute) {
        XPathExpression xPathExpression;
        String xPathExpr;
        boolean isDynamic;
        if (!baseXMLEventType.getConfigurationEventTypeXMLDOM().isXPathPropertyExpr()) {
            Property prop = PropertyParser.parseAndWalkLaxToSimple(propertyExpression);
            EventPropertyGetterSPI getter = prop.getGetterDOM();
            if (!prop.isDynamic()) {
                getter = new DOMConvertingGetter((DOMPropertyGetter)getter, String.class);
            }
            return getter;
        }
        try {
            Property property = PropertyParserNoDep.parseAndWalkLaxToSimple(propertyExpression, false);
            isDynamic = PropertyParser.isPropertyDynamic(property);
            xPathExpr = SimpleXMLPropertyParser.walk(property, baseXMLEventType.getRootElementName(), defaultNamespacePrefix, isResolvePropertiesAbsolute);
            XPath xpath = baseXMLEventType.getXPathFactory().newXPath();
            xpath.setNamespaceContext(baseXMLEventType.namespaceContext);
            if (log.isInfoEnabled()) {
                log.info("Compiling XPath expression for property '" + propertyExpression + "' as '" + xPathExpr + "'");
            }
            xPathExpression = xpath.compile(xPathExpr);
        }
        catch (XPathExpressionException e) {
            throw new EPException("Error constructing XPath expression from property name '" + propertyExpression + '\'', e);
        }
        QName xPathReturnType = isDynamic ? XPathConstants.NODE : XPathConstants.STRING;
        return new XPathPropertyGetter(baseXMLEventType, propertyExpression, xPathExpr, xPathExpression, xPathReturnType, null, null);
    }
}

