/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.xml;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

public class XPathNamespaceContext
implements NamespaceContext {
    private Map<String, String> namespaces = new HashMap<String, String>();
    private Map<String, String> prefix = new HashMap<String, String>();
    private String defaultNamespace;

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("prefix can't be null");
        }
        if (prefix.equals("")) {
            return this.defaultNamespace;
        }
        if (prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (prefix.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        String namespace = this.namespaces.get(prefix);
        if (namespace == null) {
            return "";
        }
        return namespace;
    }

    @Override
    public String getPrefix(String namespaceURI) {
        if (namespaceURI == null) {
            return null;
        }
        if (this.defaultNamespace != null && namespaceURI.equals(this.defaultNamespace)) {
            return "";
        }
        if (namespaceURI.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        if (namespaceURI.equals("http://www.w3.org/2000/xmlns/")) {
            return "xmlns";
        }
        return this.prefix.get(namespaceURI);
    }

    public Iterator getPrefixes(String namespaceURI) {
        throw new RuntimeException("Not Implemented");
    }

    public void setDefaultNamespace(String defaultNamespace) {
        this.defaultNamespace = defaultNamespace;
    }

    public void addPrefix(String prefix, String uri) {
        this.namespaces.put(prefix, uri);
        this.prefix.put(uri, prefix);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("XPathNamespaceContext default namespace '" + this.defaultNamespace + "' maps {");
        String delimiter = "";
        for (Map.Entry<String, String> entry : this.prefix.entrySet()) {
            builder.append(delimiter);
            builder.append(entry.getKey());
            builder.append("=");
            builder.append(entry.getValue());
            delimiter = ",";
        }
        builder.append("}");
        return builder.toString();
    }
}

