/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.filterspec;

import com.espertech.esper.common.internal.filterspec.Range;

public final class DoubleRange
implements Range {
    private Double min;
    private Double max;
    private int hashCode;

    public DoubleRange(Double min, Double max) {
        this.min = min;
        this.max = max;
        if (min != null && max != null && min > max) {
            this.max = min;
            this.min = max;
        }
        this.hashCode = 7;
        if (min != null) {
            this.hashCode = 31 * this.hashCode;
            this.hashCode ^= min.hashCode();
        }
        if (max != null) {
            this.hashCode = 31 * this.hashCode;
            this.hashCode ^= max.hashCode();
        }
    }

    public final Double getMin() {
        return this.min;
    }

    @Override
    public Object getHighEndpoint() {
        return this.max;
    }

    @Override
    public Object getLowEndpoint() {
        return this.min;
    }

    public final Double getMax() {
        return this.max;
    }

    public final boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof DoubleRange)) {
            return false;
        }
        DoubleRange otherRange = (DoubleRange)other;
        return otherRange.max.doubleValue() == this.max.doubleValue() && otherRange.min.doubleValue() == this.min.doubleValue();
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final String toString() {
        return "DoubleRange min=" + this.min + " max=" + this.max;
    }
}

