/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.filterspec;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamFilterForEvalForge;
import com.espertech.esper.common.internal.filterspec.MatchedEventMap;

public class FilterForEvalConstantStringForge
implements FilterSpecParamFilterForEvalForge {
    private final String theStringValue;

    public FilterForEvalConstantStringForge(String theStringValue) {
        this.theStringValue = theStringValue;
    }

    @Override
    public final String getFilterValue(MatchedEventMap matchedEvents, ExprEvaluatorContext exprEvaluatorContext) {
        return this.theStringValue;
    }

    public final String toString() {
        return this.theStringValue;
    }

    @Override
    public CodegenExpression makeCodegen(CodegenClassScope classScope, CodegenMethodScope parent) {
        return CodegenExpressionBuilder.constant(this.theStringValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterForEvalConstantStringForge that = (FilterForEvalConstantStringForge)o;
        return !(this.theStringValue != null ? !this.theStringValue.equals(that.theStringValue) : that.theStringValue != null);
    }

    public int hashCode() {
        return this.theStringValue != null ? this.theStringValue.hashCode() : 0;
    }

    @Override
    public void valueToString(StringBuilder out) {
        out.append("string-type constant '").append(this.theStringValue).append("'");
    }
}

