/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.filterspec;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeDeployTimeConst;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityMake;
import com.espertech.esper.common.internal.filterspec.FilterSpecParam;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamInValueForge;
import com.espertech.esper.common.internal.filterspec.MatchedEventMap;
import com.espertech.esper.common.internal.util.SimpleNumberCoercer;

public class FilterForEvalDeployTimeConstForge
implements FilterSpecParamInValueForge {
    private final transient ExprNodeDeployTimeConst deployTimeConst;
    private final transient SimpleNumberCoercer numberCoercer;
    private final transient Class returnType;

    public FilterForEvalDeployTimeConstForge(ExprNodeDeployTimeConst deployTimeConst, SimpleNumberCoercer numberCoercer, Class returnType) {
        this.deployTimeConst = deployTimeConst;
        this.numberCoercer = numberCoercer;
        this.returnType = returnType;
    }

    @Override
    public CodegenExpression makeCodegen(CodegenClassScope classScope, CodegenMethodScope parent) {
        CodegenMethod method = parent.makeChild(Object.class, this.getClass(), (CodegenScope)classScope).addParam(FilterSpecParam.GET_FILTER_VALUE_FP);
        CodegenExpression value = this.deployTimeConst.codegenGetDeployTimeConstValue(classScope);
        if (this.numberCoercer != null) {
            value = this.numberCoercer.coerceCodegenMayNullBoxed(value, this.returnType, method, classScope);
        }
        method.getBlock().methodReturn(value);
        return CodegenExpressionBuilder.localMethod(method, FilterSpecParam.GET_FILTER_VALUE_REFS);
    }

    @Override
    public Class getReturnType() {
        return this.returnType;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public Object getFilterValue(MatchedEventMap matchedEvents, ExprEvaluatorContext evaluatorContext) {
        throw ExprNodeUtilityMake.makeUnsupportedCompileTime();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterForEvalDeployTimeConstForge that = (FilterForEvalDeployTimeConstForge)o;
        return this.deployTimeConst.equals(that.deployTimeConst);
    }

    public int hashCode() {
        return this.deployTimeConst.hashCode();
    }

    @Override
    public void valueToString(StringBuilder out) {
        out.append("deploy-time constant ");
        this.deployTimeConst.renderForFilterPlan(out);
    }
}

