/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.filterspec;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.epl.expression.codegen.CodegenLegoMethodExpression;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenNames;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.pattern.core.MatchedEventConvertorForge;
import com.espertech.esper.common.internal.filterspec.FilterSpecParam;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamInValueForge;
import com.espertech.esper.common.internal.filterspec.MatchedEventMap;
import com.espertech.esper.common.internal.util.SimpleNumberCoercer;

public class FilterForEvalLimitedExprForge
implements FilterSpecParamInValueForge {
    private final ExprNode value;
    private final MatchedEventConvertorForge convertor;
    private final SimpleNumberCoercer numberCoercer;

    public FilterForEvalLimitedExprForge(ExprNode value, MatchedEventConvertorForge convertor, SimpleNumberCoercer numberCoercer) {
        this.value = value;
        this.convertor = convertor;
        this.numberCoercer = numberCoercer;
    }

    @Override
    public CodegenExpression makeCodegen(CodegenClassScope classScope, CodegenMethodScope parent) {
        CodegenMethod method = parent.makeChild(Object.class, this.getClass(), (CodegenScope)classScope).addParam(FilterSpecParam.GET_FILTER_VALUE_FP);
        CodegenMethod rhsExpression = CodegenLegoMethodExpression.codegenExpression(this.value.getForge(), method, classScope);
        CodegenMethod matchEventConvertor = this.convertor.make(method, classScope);
        CodegenExpression valueExpr = CodegenExpressionBuilder.localMethod(rhsExpression, CodegenExpressionBuilder.ref("eps"), CodegenExpressionBuilder.constantTrue(), ExprForgeCodegenNames.REF_EXPREVALCONTEXT);
        if (this.numberCoercer != null) {
            valueExpr = this.numberCoercer.coerceCodegenMayNullBoxed(valueExpr, this.value.getForge().getEvaluationType(), method, classScope);
        }
        method.getBlock().declareVar(EventBean[].class, "eps", (CodegenExpression)CodegenExpressionBuilder.localMethod(matchEventConvertor, FilterSpecParam.REF_MATCHEDEVENTMAP)).methodReturn(valueExpr);
        return CodegenExpressionBuilder.localMethod(method, FilterSpecParam.GET_FILTER_VALUE_REFS);
    }

    @Override
    public Class getReturnType() {
        return this.value.getForge().getEvaluationType();
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public Object getFilterValue(MatchedEventMap matchedEvents, ExprEvaluatorContext exprEvaluatorContext) {
        return null;
    }

    @Override
    public void valueToString(StringBuilder out) {
        out.append("expression '").append(ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(this.value)).append("'");
    }
}

