/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.filterspec;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionNewAnonymousClass;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionUtil;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbolWEventType;
import com.espertech.esper.common.internal.epl.expression.core.ExprFilterSpecLookupable;
import com.espertech.esper.common.internal.epl.expression.core.ExprFilterSpecLookupableForge;
import com.espertech.esper.common.internal.filterspec.FilterOperator;
import com.espertech.esper.common.internal.filterspec.FilterSpecParam;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamForge;
import com.espertech.esper.common.internal.filterspec.FilterValueSetParam;
import com.espertech.esper.common.internal.filterspec.FilterValueSetParamImpl;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.Arrays;
import java.util.Collections;

public final class FilterSpecParamConstantForge
extends FilterSpecParamForge {
    private final Object filterConstant;

    public FilterSpecParamConstantForge(ExprFilterSpecLookupableForge lookupable, FilterOperator filterOperator, Object filterConstant) throws IllegalArgumentException {
        super(lookupable, filterOperator);
        this.filterConstant = filterConstant;
        if (filterOperator.isRangeOperator()) {
            throw new IllegalArgumentException("Illegal filter operator " + (Object)((Object)filterOperator) + " supplied to constant filter parameter");
        }
    }

    @Override
    public CodegenMethod makeCodegen(CodegenClassScope classScope, CodegenMethodScope parent, SAIFFInitializeSymbolWEventType symbols) {
        CodegenMethod method = parent.makeChild(FilterSpecParam.class, FilterSpecParamConstantForge.class, (CodegenScope)classScope);
        method.getBlock().declareVar(ExprFilterSpecLookupable.class, "lookupable", (CodegenExpression)CodegenExpressionBuilder.localMethod(this.lookupable.makeCodegen(method, symbols, classScope), new CodegenExpression[0])).declareVar(FilterOperator.class, "op", CodegenExpressionBuilder.enumValue(FilterOperator.class, this.filterOperator.name()));
        CodegenExpressionNewAnonymousClass inner = CodegenExpressionBuilder.newAnonymousClass(method.getBlock(), FilterSpecParam.class, Arrays.asList(CodegenExpressionBuilder.ref("lookupable"), CodegenExpressionBuilder.ref("op")));
        CodegenMethod getFilterValue = CodegenMethod.makeParentNode(FilterValueSetParam.class, this.getClass(), classScope).addParam(FilterSpecParam.GET_FILTER_VALUE_FP);
        inner.addMethod("getFilterValue", getFilterValue);
        getFilterValue.getBlock().methodReturn(FilterValueSetParamImpl.codegenNew(CodegenExpressionBuilder.constant(this.filterConstant)));
        method.getBlock().methodReturn(inner);
        return method;
    }

    public Object getFilterConstant() {
        return this.filterConstant;
    }

    public final String toString() {
        return super.toString() + " filterConstant=" + this.filterConstant;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FilterSpecParamConstantForge that = (FilterSpecParamConstantForge)o;
        return !(this.filterConstant != null ? !this.filterConstant.equals(that.filterConstant) : that.filterConstant != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.filterConstant != null ? this.filterConstant.hashCode() : 0);
        return result;
    }

    @Override
    public void valueExprToString(StringBuilder out, int i) {
        FilterSpecParamConstantForge.valueExprToString(out, this.filterConstant);
    }

    public static void valueExprToString(StringBuilder out, Object constant) {
        out.append("constant ");
        CodegenExpressionUtil.renderConstant(out, constant, Collections.emptyMap());
        out.append(" type ").append(JavaClassHelper.getClassNameFullyQualPretty(constant == null ? null : constant.getClass()));
    }

    public static String valueExprToString(Object constant) {
        StringBuilder builder = new StringBuilder();
        FilterSpecParamConstantForge.valueExprToString(builder, constant);
        return builder.toString();
    }
}

