/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.filterspec;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionNewAnonymousClass;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbolWEventType;
import com.espertech.esper.common.internal.epl.expression.core.ExprFilterSpecLookupable;
import com.espertech.esper.common.internal.epl.expression.core.ExprFilterSpecLookupableForge;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterSPI;
import com.espertech.esper.common.internal.event.core.EventTypeSPI;
import com.espertech.esper.common.internal.filterspec.FilterOperator;
import com.espertech.esper.common.internal.filterspec.FilterSpecParam;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamConstantForge;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamForge;
import com.espertech.esper.common.internal.filterspec.FilterValueSetParam;
import com.espertech.esper.common.internal.filterspec.FilterValueSetParamImpl;
import com.espertech.esper.common.internal.util.SimpleNumberCoercer;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FilterSpecParamEventPropIndexedForge
extends FilterSpecParamForge {
    private static final Logger log = LoggerFactory.getLogger(FilterSpecParamEventPropIndexedForge.class);
    private final String resultEventAsName;
    private final int resultEventIndex;
    private final String resultEventProperty;
    private final EventType eventType;
    private final boolean isMustCoerce;
    private final transient SimpleNumberCoercer numberCoercer;
    private final Class coercionType;
    private final String statementName;

    public FilterSpecParamEventPropIndexedForge(ExprFilterSpecLookupableForge lookupable, FilterOperator filterOperator, String resultEventAsName, int resultEventIndex, String resultEventProperty, EventType eventType, boolean isMustCoerce, SimpleNumberCoercer numberCoercer, Class coercionType, String statementName) throws IllegalArgumentException {
        super(lookupable, filterOperator);
        this.resultEventAsName = resultEventAsName;
        this.resultEventIndex = resultEventIndex;
        this.resultEventProperty = resultEventProperty;
        this.eventType = eventType;
        this.isMustCoerce = isMustCoerce;
        this.numberCoercer = numberCoercer;
        this.coercionType = coercionType;
        this.statementName = statementName;
        if (filterOperator.isRangeOperator()) {
            throw new IllegalArgumentException("Illegal filter operator " + (Object)((Object)filterOperator) + " supplied to event property filter parameter");
        }
    }

    @Override
    public CodegenMethod makeCodegen(CodegenClassScope classScope, CodegenMethodScope parent, SAIFFInitializeSymbolWEventType symbols) {
        EventPropertyGetterSPI getterSPI = ((EventTypeSPI)this.eventType).getGetterSPI(this.resultEventProperty);
        CodegenMethod method = parent.makeChild(FilterSpecParam.class, FilterSpecParamConstantForge.class, (CodegenScope)classScope);
        method.getBlock().declareVar(ExprFilterSpecLookupable.class, "lookupable", (CodegenExpression)CodegenExpressionBuilder.localMethod(this.lookupable.makeCodegen(method, symbols, classScope), new CodegenExpression[0])).declareVar(FilterOperator.class, "op", CodegenExpressionBuilder.enumValue(FilterOperator.class, this.filterOperator.name()));
        CodegenExpressionNewAnonymousClass param = CodegenExpressionBuilder.newAnonymousClass(method.getBlock(), FilterSpecParam.class, Arrays.asList(CodegenExpressionBuilder.ref("lookupable"), CodegenExpressionBuilder.ref("op")));
        CodegenMethod getFilterValue = CodegenMethod.makeParentNode(FilterValueSetParam.class, this.getClass(), classScope).addParam(FilterSpecParam.GET_FILTER_VALUE_FP);
        param.addMethod("getFilterValue", getFilterValue);
        getFilterValue.getBlock().declareVar(EventBean[].class, "events", CodegenExpressionBuilder.cast(EventBean[].class, CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("matchedEvents"), "getMatchingEventAsObjectByTag", CodegenExpressionBuilder.constant(this.resultEventAsName)))).declareVar(Object.class, "value", CodegenExpressionBuilder.constantNull()).ifRefNotNull("events").assignRef("value", getterSPI.eventBeanGetCodegen(CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.ref("events"), CodegenExpressionBuilder.constant(this.resultEventIndex)), method, classScope)).blockEnd();
        if (this.isMustCoerce) {
            getFilterValue.getBlock().assignRef("value", this.numberCoercer.coerceCodegenMayNullBoxed(CodegenExpressionBuilder.cast(Number.class, (CodegenExpression)CodegenExpressionBuilder.ref("value")), Number.class, method, classScope));
        }
        getFilterValue.getBlock().methodReturn(FilterValueSetParamImpl.codegenNew(CodegenExpressionBuilder.ref("value")));
        method.getBlock().methodReturn(param);
        return method;
    }

    public boolean isMustCoerce() {
        return this.isMustCoerce;
    }

    public Class getCoercionType() {
        return this.coercionType;
    }

    public String getResultEventAsName() {
        return this.resultEventAsName;
    }

    public String getResultEventProperty() {
        return this.resultEventProperty;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public int getResultEventIndex() {
        return this.resultEventIndex;
    }

    public final String toString() {
        return super.toString() + " resultEventAsName=" + this.resultEventAsName + " resultEventProperty=" + this.resultEventProperty;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FilterSpecParamEventPropIndexedForge)) {
            return false;
        }
        FilterSpecParamEventPropIndexedForge other = (FilterSpecParamEventPropIndexedForge)obj;
        if (!super.equals(other)) {
            return false;
        }
        return this.resultEventAsName.equals(other.resultEventAsName) && this.resultEventProperty.equals(other.resultEventProperty) && this.resultEventIndex == other.resultEventIndex;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.resultEventProperty.hashCode();
        return result;
    }

    @Override
    public void valueExprToString(StringBuilder out, int i) {
        out.append("indexed event property '").append(this.resultEventProperty).append("'");
    }
}

