/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.filterspec;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionNewAnonymousClass;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbolWEventType;
import com.espertech.esper.common.internal.epl.expression.codegen.CodegenLegoMethodExpression;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenNames;
import com.espertech.esper.common.internal.epl.expression.core.ExprFilterSpecLookupable;
import com.espertech.esper.common.internal.epl.expression.core.ExprFilterSpecLookupableForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.pattern.core.MatchedEventConvertorForge;
import com.espertech.esper.common.internal.filterspec.FilterOperator;
import com.espertech.esper.common.internal.filterspec.FilterSpecParam;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamForge;
import com.espertech.esper.common.internal.filterspec.FilterValueSetParam;
import com.espertech.esper.common.internal.filterspec.FilterValueSetParamImpl;
import com.espertech.esper.common.internal.util.SimpleNumberCoercer;
import java.util.Arrays;

public class FilterSpecParamValueLimitedExprForge
extends FilterSpecParamForge {
    private final ExprNode value;
    private final MatchedEventConvertorForge convertor;
    private final SimpleNumberCoercer numberCoercer;

    public FilterSpecParamValueLimitedExprForge(ExprFilterSpecLookupableForge lookupable, FilterOperator filterOperator, ExprNode value, MatchedEventConvertorForge convertor, SimpleNumberCoercer numberCoercer) {
        super(lookupable, filterOperator);
        this.value = value;
        this.convertor = convertor;
        this.numberCoercer = numberCoercer;
    }

    @Override
    public CodegenMethod makeCodegen(CodegenClassScope classScope, CodegenMethodScope parent, SAIFFInitializeSymbolWEventType symbols) {
        CodegenMethod method = parent.makeChild(FilterSpecParam.class, this.getClass(), (CodegenScope)classScope);
        CodegenMethod rhsExpression = CodegenLegoMethodExpression.codegenExpression(this.value.getForge(), method, classScope);
        CodegenMethod matchEventConvertor = this.convertor.make(method, classScope);
        method.getBlock().declareVar(ExprFilterSpecLookupable.class, "lookupable", (CodegenExpression)CodegenExpressionBuilder.localMethod(this.lookupable.makeCodegen(method, symbols, classScope), new CodegenExpression[0])).declareVar(FilterOperator.class, "op", CodegenExpressionBuilder.enumValue(FilterOperator.class, this.filterOperator.name()));
        CodegenExpressionNewAnonymousClass param = CodegenExpressionBuilder.newAnonymousClass(method.getBlock(), FilterSpecParam.class, Arrays.asList(CodegenExpressionBuilder.ref("lookupable"), CodegenExpressionBuilder.ref("op")));
        CodegenMethod getFilterValue = CodegenMethod.makeParentNode(FilterValueSetParam.class, this.getClass(), classScope).addParam(FilterSpecParam.GET_FILTER_VALUE_FP);
        param.addMethod("getFilterValue", getFilterValue);
        CodegenExpression valueExpr = CodegenExpressionBuilder.localMethod(rhsExpression, CodegenExpressionBuilder.ref("eps"), CodegenExpressionBuilder.constantTrue(), ExprForgeCodegenNames.REF_EXPREVALCONTEXT);
        if (this.numberCoercer != null) {
            valueExpr = this.numberCoercer.coerceCodegenMayNullBoxed(valueExpr, this.value.getForge().getEvaluationType(), method, classScope);
        }
        getFilterValue.getBlock().declareVar(EventBean[].class, "eps", (CodegenExpression)CodegenExpressionBuilder.localMethod(matchEventConvertor, FilterSpecParam.REF_MATCHEDEVENTMAP)).methodReturn(FilterValueSetParamImpl.codegenNew(valueExpr));
        method.getBlock().methodReturn(param);
        return method;
    }

    @Override
    public void valueExprToString(StringBuilder out, int i) {
        out.append("expression '").append(ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(this.value)).append("'");
    }
}

