/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.metrics.audit;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.annotation.AuditEnum;
import com.espertech.esper.common.client.dataflow.core.EPDataFlowState;
import com.espertech.esper.common.internal.collection.LRUCache;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.EPStatementHandleCallbackSchedule;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.pattern.core.EvalFactoryNode;
import com.espertech.esper.common.internal.filterspec.MatchedEventMapMinimal;
import com.espertech.esper.common.internal.metrics.audit.AuditCallback;
import com.espertech.esper.common.internal.metrics.audit.AuditContext;
import com.espertech.esper.common.internal.metrics.audit.AuditPatternInstanceKey;
import com.espertech.esper.common.internal.schedule.ScheduleHandle;
import com.espertech.esper.common.internal.schedule.ScheduleObjectType;
import com.espertech.esper.common.internal.util.EventBeanSummarizer;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.view.core.ViewFactory;
import java.io.StringWriter;
import java.time.Instant;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditPath {
    private static final Logger AUDIT_LOG_DESTINATION = LoggerFactory.getLogger((String)"com.espertech.esper.audit");
    private static LRUCache<AuditPatternInstanceKey, Integer> patternInstanceCounts;
    private static volatile AuditCallback auditCallback;
    public static final String QUERYPLAN_LOG = "com.espertech.esper.queryplan";
    public static final String JDBC_LOG = "com.espertech.esper.jdbc";
    public static final String AUDIT_LOG = "com.espertech.esper.audit";
    public static boolean isAuditEnabled;
    private static String auditPattern;

    public static void setAuditPattern(String auditPattern) {
        AuditPath.auditPattern = auditPattern;
    }

    public static void auditInsert(EventBean theEvent, ExprEvaluatorContext exprEvaluatorContext) {
        AuditPath.auditLog(exprEvaluatorContext, AuditEnum.INSERT, EventBeanSummarizer.summarize(theEvent));
    }

    public static void auditView(EventBean[] newData, EventBean[] oldData, ExprEvaluatorContext context, ViewFactory viewFactory) {
        if (AuditPath.isInfoEnabled()) {
            AuditPath.auditLog(context, AuditEnum.VIEW, viewFactory.getViewName() + " insert {" + EventBeanSummarizer.summarize(newData) + "} remove {" + EventBeanSummarizer.summarize(oldData) + "}");
        }
    }

    public static void auditStream(EventBean event, ExprEvaluatorContext context, String filterText) {
        if (AuditPath.isInfoEnabled()) {
            String eventText = EventBeanSummarizer.summarize(event);
            AuditPath.auditLog(context, AuditEnum.STREAM, filterText + " inserted " + eventText);
        }
    }

    public static void auditStream(EventBean[] newData, EventBean[] oldData, ExprEvaluatorContext context, String filterText) {
        if (AuditPath.isInfoEnabled()) {
            String inserted = EventBeanSummarizer.summarize(newData);
            String removed = EventBeanSummarizer.summarize(oldData);
            AuditPath.auditLog(context, AuditEnum.STREAM, filterText + " insert {" + inserted + "} remove {" + removed + "}");
        }
    }

    public static void auditScheduleAdd(long nextScheduledTime, AgentInstanceContext agentInstanceContext, ScheduleHandle scheduleHandle, ScheduleObjectType objectType, String name) {
        if (AuditPath.isInfoEnabled()) {
            StringWriter message = new StringWriter();
            message.write("add after ");
            message.write(Long.toString(nextScheduledTime));
            AuditPath.printScheduleObjectType(message, objectType, name, scheduleHandle);
            AuditPath.auditLog(agentInstanceContext, AuditEnum.SCHEDULE, message.toString());
        }
    }

    public static void auditScheduleRemove(AgentInstanceContext agentInstanceContext, ScheduleHandle scheduleHandle, ScheduleObjectType objectType, String name) {
        if (AuditPath.isInfoEnabled()) {
            StringWriter message = new StringWriter();
            message.write("remove");
            AuditPath.printScheduleObjectType(message, objectType, name, scheduleHandle);
            AuditPath.auditLog(agentInstanceContext, AuditEnum.SCHEDULE, message.toString());
        }
    }

    public static void auditScheduleFire(AgentInstanceContext agentInstanceContext, ScheduleObjectType objectType, String name) {
        if (AuditPath.isInfoEnabled()) {
            StringWriter message = new StringWriter();
            message.write("fire");
            AuditPath.printScheduleObjectType(message, objectType, name);
            AuditPath.auditLog(agentInstanceContext, AuditEnum.SCHEDULE, message.toString());
        }
    }

    public static void auditProperty(String name, Object value, ExprEvaluatorContext exprEvaluatorContext) {
        if (AuditPath.isInfoEnabled()) {
            StringWriter message = new StringWriter();
            message.append(name).append(" value ");
            AuditPath.renderNonParameterValue(message, value);
            AuditPath.auditLog(exprEvaluatorContext, AuditEnum.PROPERTY, message.toString());
        }
    }

    public static void auditExpression(String text, Object value, ExprEvaluatorContext exprEvaluatorContext) {
        if (AuditPath.isInfoEnabled()) {
            StringWriter message = new StringWriter();
            message.append(text).append(" value ");
            AuditPath.renderNonParameterValue(message, value);
            AuditPath.auditLog(exprEvaluatorContext, AuditEnum.EXPRESSION, message.toString());
        }
    }

    public static void auditPatternTrue(EvalFactoryNode factoryNode, Object from, MatchedEventMapMinimal matchEvent, boolean isQuitted, AgentInstanceContext agentInstanceContext) {
        if (AuditPath.isInfoEnabled()) {
            String message = AuditPath.patternToStringEvaluateTrue(factoryNode, matchEvent, from, isQuitted);
            AuditPath.auditLog(agentInstanceContext, AuditEnum.PATTERN, message.toString());
        }
    }

    public static void auditPatternFalse(EvalFactoryNode factoryNode, Object from, AgentInstanceContext agentInstanceContext) {
        if (AuditPath.isInfoEnabled()) {
            String message = AuditPath.patternToStringEvaluateFalse(factoryNode, from);
            AuditPath.auditLog(agentInstanceContext, AuditEnum.PATTERN, message.toString());
        }
    }

    public static void auditExprDef(String name, Object value, ExprEvaluatorContext exprEvaluatorContext) {
        if (AuditPath.isInfoEnabled()) {
            StringWriter message = new StringWriter();
            message.append(name).append(" value ");
            AuditPath.renderNonParameterValue(message, value);
            AuditPath.auditLog(exprEvaluatorContext, AuditEnum.EXPRDEF, message.toString());
        }
    }

    public static synchronized void auditPatternInstance(boolean increase, EvalFactoryNode factoryNode, AgentInstanceContext agentInstanceContext) {
        if (AuditPath.isInfoEnabled()) {
            AuditPatternInstanceKey key;
            Integer existing;
            if (patternInstanceCounts == null) {
                patternInstanceCounts = new LRUCache(100);
            }
            int count = (existing = (Integer)patternInstanceCounts.get(key = new AuditPatternInstanceKey(agentInstanceContext.getRuntimeURI(), agentInstanceContext.getStatementId(), agentInstanceContext.getAgentInstanceId(), factoryNode.getTextForAudit()))) == null ? (increase ? 1 : 0) : existing + (increase ? 1 : -1);
            StringWriter writer = new StringWriter();
            patternInstanceCounts.put(key, count);
            AuditPath.writePatternExpr(factoryNode, writer);
            if (increase) {
                writer.write(" increased to " + count);
            } else {
                writer.write(" decreased to " + count);
            }
            AuditPath.auditLog(agentInstanceContext, AuditEnum.PATTERNINSTANCES, writer.toString());
        }
    }

    public static void auditDataflowTransition(String dataflowName, String dataFlowInstanceId, EPDataFlowState state, EPDataFlowState newState, AgentInstanceContext agentInstanceContext) {
        if (AuditPath.isInfoEnabled()) {
            StringWriter message = new StringWriter();
            AuditPath.writeDataflow(message, dataflowName, dataFlowInstanceId);
            message.append(" from state ").append(state == null ? "(none)" : state.name()).append(" to state ").append(newState.toString());
            AuditPath.auditLog(agentInstanceContext, AuditEnum.DATAFLOW_TRANSITION, message.toString());
        }
    }

    public static void auditDataflowSource(String dataflowName, String dataFlowInstanceId, String operatorName, int operatorNumber, AgentInstanceContext agentInstanceContext) {
        if (AuditPath.isInfoEnabled()) {
            StringWriter message = new StringWriter();
            AuditPath.writeDataflow(message, dataflowName, dataFlowInstanceId);
            AuditPath.writeDataflowOp(message, operatorName, operatorNumber);
            message.append(" invoking source.next()");
            AuditPath.auditLog(agentInstanceContext, AuditEnum.DATAFLOW_SOURCE, message.toString());
        }
    }

    public static void auditDataflowOp(String dataflowName, String dataFlowInstanceId, String operatorName, int operatorNumber, Object[] params, AgentInstanceContext agentInstanceContext) {
        if (AuditPath.isInfoEnabled()) {
            StringWriter message = new StringWriter();
            AuditPath.writeDataflow(message, dataflowName, dataFlowInstanceId);
            AuditPath.writeDataflowOp(message, operatorName, operatorNumber);
            message.append(" parameters ").append(Arrays.toString(params));
            AuditPath.auditLog(agentInstanceContext, AuditEnum.DATAFLOW_OP, message.toString());
        }
    }

    public static void auditContextPartition(boolean allocate, AgentInstanceContext agentInstanceContext) {
        if (AuditPath.isInfoEnabled()) {
            StringWriter writer = new StringWriter();
            writer.write(allocate ? "Allocate" : "Destroy");
            writer.write(" cpid ");
            writer.write(Integer.toString(agentInstanceContext.getAgentInstanceId()));
            AuditPath.auditLog(agentInstanceContext, AuditEnum.CONTEXTPARTITION, writer.toString());
        }
    }

    private static void auditLog(ExprEvaluatorContext ctx, AuditEnum category, String message) {
        if (auditPattern == null) {
            String text = AuditContext.defaultFormat(ctx.getStatementName(), ctx.getAgentInstanceId(), category, message);
            AUDIT_LOG_DESTINATION.info(text);
        } else {
            Instant instant;
            long time;
            String result = auditPattern.replace("%s", ctx.getStatementName()).replace("%d", ctx.getDeploymentId()).replace("%u", ctx.getRuntimeURI()).replace("%i", Integer.toString(ctx.getAgentInstanceId())).replace("%c", category.getValue()).replace("%m", message);
            if (auditPattern.contains("%tutc")) {
                time = ctx.getTimeProvider().getTime();
                instant = Instant.ofEpochMilli(time);
                result = result.replace("%tutc", instant.toString());
            }
            if (auditPattern.contains("%tzone")) {
                time = ctx.getTimeProvider().getTime();
                instant = Instant.ofEpochMilli(time);
                String formatted = ctx.getTimeProvider().getDefaultFormatter().format(instant);
                result = result.replace("%tzone", formatted);
            }
            AUDIT_LOG_DESTINATION.info(result);
        }
        if (auditCallback != null) {
            auditCallback.audit(new AuditContext(ctx.getRuntimeURI(), ctx.getDeploymentId(), ctx.getStatementName(), ctx.getAgentInstanceId(), category, ctx.getTimeProvider().getTime(), message));
        }
    }

    public static boolean isInfoEnabled() {
        return AUDIT_LOG_DESTINATION.isInfoEnabled() || auditCallback != null;
    }

    public static void setAuditCallback(AuditCallback auditCallback) {
        AuditPath.auditCallback = auditCallback;
    }

    public static AuditCallback getAuditCallback() {
        return auditCallback;
    }

    private static void printScheduleObjectType(StringWriter message, ScheduleObjectType objectType, String name) {
        message.append(" ").append(objectType.name()).append(" '").append(name).append("'");
    }

    private static void printScheduleObjectType(StringWriter message, ScheduleObjectType objectType, String name, ScheduleHandle scheduleHandle) {
        AuditPath.printScheduleObjectType(message, objectType, name);
        message.append(" handle '");
        AuditPath.printHandle(message, scheduleHandle);
        message.append("'");
    }

    private static void printHandle(StringWriter message, ScheduleHandle handle) {
        if (handle instanceof EPStatementHandleCallbackSchedule) {
            EPStatementHandleCallbackSchedule callback = (EPStatementHandleCallbackSchedule)handle;
            JavaClassHelper.writeInstance(message, callback.getScheduleCallback(), false);
        } else {
            JavaClassHelper.writeInstance(message, handle, false);
        }
    }

    private static String patternToStringEvaluateTrue(EvalFactoryNode factoryNode, MatchedEventMapMinimal matchEvent, Object fromNode, boolean isQuitted) {
        StringWriter writer = new StringWriter();
        AuditPath.writePatternExpr(factoryNode, writer);
        writer.write(" evaluate-true {");
        writer.write(" from: ");
        JavaClassHelper.writeInstance(writer, fromNode, false);
        writer.write(" map: {");
        String delimiter = "";
        Object[] data = matchEvent.getMatchingEvents();
        for (int i = 0; i < data.length; ++i) {
            String name = matchEvent.getMeta().getTagsPerIndex()[i];
            Object value = data[i];
            writer.write(delimiter);
            writer.write(name);
            writer.write("=");
            if (value instanceof EventBean) {
                writer.write(((EventBean)value).getUnderlying().toString());
            } else if (value instanceof EventBean[]) {
                writer.write(EventBeanSummarizer.summarize((EventBean[])value));
            }
            delimiter = ", ";
        }
        writer.write("} quitted: ");
        writer.write(Boolean.toString(isQuitted));
        writer.write("}");
        return writer.toString();
    }

    private static String patternToStringEvaluateFalse(EvalFactoryNode factoryNode, Object fromNode) {
        StringWriter writer = new StringWriter();
        AuditPath.writePatternExpr(factoryNode, writer);
        writer.write(" evaluate-false {");
        writer.write(" from ");
        JavaClassHelper.writeInstance(writer, fromNode, false);
        writer.write("}");
        return writer.toString();
    }

    private static void renderNonParameterValue(StringWriter message, Object value) {
        JavaClassHelper.getObjectValuePretty(value, message);
    }

    private static void writeDataflow(StringWriter message, String dataflowName, String dataFlowInstanceId) {
        message.append("dataflow ").append(dataflowName).append(" instance ").append(dataFlowInstanceId == null ? "(unnamed)" : dataFlowInstanceId);
    }

    private static void writeDataflowOp(StringWriter message, String operatorName, int operatorNumber) {
        message.append(" operator ").append(operatorName).append("(").append(Integer.toString(operatorNumber)).append(")");
    }

    private static void writePatternExpr(EvalFactoryNode factoryNode, StringWriter writer) {
        if (factoryNode.getTextForAudit() != null) {
            writer.write(40);
            writer.write(factoryNode.getTextForAudit());
            writer.write(41);
        } else {
            JavaClassHelper.writeInstance(writer, "subexr", factoryNode);
        }
    }

    static {
        isAuditEnabled = false;
    }
}

