/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.metrics.instrumentation;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprForgeInstrumentable;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class InstrumentationBuilderExpr {
    private final Class generator;
    private final ExprForgeInstrumentable forge;
    private final String qname;
    private final Class requiredType;
    private final CodegenMethodScope codegenMethodScope;
    private final ExprForgeCodegenSymbol exprSymbol;
    private final CodegenClassScope codegenClassScope;
    private final List<CodegenExpression> qParams = new ArrayList<CodegenExpression>();

    public InstrumentationBuilderExpr(Class generator, ExprForgeInstrumentable forge, String qname, Class requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        this.generator = generator;
        this.forge = forge;
        this.qname = qname;
        this.requiredType = requiredType;
        this.codegenMethodScope = codegenMethodScope;
        this.exprSymbol = exprSymbol;
        this.codegenClassScope = codegenClassScope;
        String text = ExprNodeUtilityPrint.toExpressionStringMinPrecedence(forge);
        this.qParams.add(0, CodegenExpressionBuilder.constant(text));
    }

    public CodegenExpression build() {
        if (!this.codegenClassScope.isInstrumented()) {
            return this.forge.evaluateCodegenUninstrumented(this.requiredType, this.codegenMethodScope, this.exprSymbol, this.codegenClassScope);
        }
        Class evaluationType = this.forge.getEvaluationType();
        if (evaluationType == Void.TYPE) {
            return CodegenExpressionBuilder.constantNull();
        }
        if (evaluationType == null) {
            CodegenMethod method = this.codegenMethodScope.makeChild(Object.class, this.generator, (CodegenScope)this.codegenClassScope);
            method.getBlock().ifCondition(CodegenExpressionBuilder.publicConstValue("com.espertech.esper.runtime.internal.metrics.instrumentation.InstrumentationHelper", "ENABLED")).expression(CodegenExpressionBuilder.exprDotMethodChain(CodegenExpressionBuilder.staticMethod("com.espertech.esper.runtime.internal.metrics.instrumentation.InstrumentationHelper", "get", new CodegenExpression[0])).add("q" + this.qname, this.qParams.toArray(new CodegenExpression[this.qParams.size()]))).expression(CodegenExpressionBuilder.exprDotMethodChain(CodegenExpressionBuilder.staticMethod("com.espertech.esper.runtime.internal.metrics.instrumentation.InstrumentationHelper", "get", new CodegenExpression[0])).add("a" + this.qname, CodegenExpressionBuilder.constantNull())).blockEnd().methodReturn(CodegenExpressionBuilder.constantNull());
            return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
        }
        CodegenMethod method = this.codegenMethodScope.makeChild(evaluationType, this.generator, (CodegenScope)this.codegenClassScope);
        CodegenExpression expr = this.forge.evaluateCodegenUninstrumented(evaluationType, method, this.exprSymbol, this.codegenClassScope);
        method.getBlock().ifCondition(CodegenExpressionBuilder.publicConstValue("com.espertech.esper.runtime.internal.metrics.instrumentation.InstrumentationHelper", "ENABLED")).expression(CodegenExpressionBuilder.exprDotMethodChain(CodegenExpressionBuilder.staticMethod("com.espertech.esper.runtime.internal.metrics.instrumentation.InstrumentationHelper", "get", new CodegenExpression[0])).add("q" + this.qname, this.qParams.toArray(new CodegenExpression[this.qParams.size()]))).declareVar(evaluationType, "result", expr).expression(CodegenExpressionBuilder.exprDotMethodChain(CodegenExpressionBuilder.staticMethod("com.espertech.esper.runtime.internal.metrics.instrumentation.InstrumentationHelper", "get", new CodegenExpression[0])).add("a" + this.qname, CodegenExpressionBuilder.ref("result"))).blockReturn(CodegenExpressionBuilder.ref("result")).methodReturn(expr);
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }

    public InstrumentationBuilderExpr noqparam() {
        this.qParams.clear();
        return this;
    }

    public InstrumentationBuilderExpr qparam(CodegenExpression qparam) {
        this.qParams.add(qparam);
        return this;
    }

    public InstrumentationBuilderExpr qparams(CodegenExpression ... qparams) {
        this.qParams.addAll(Arrays.asList(qparams));
        return this;
    }
}

