/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.metrics.stmtmetrics;

import com.espertech.esper.common.client.metric.RuntimeMetric;
import com.espertech.esper.common.internal.metrics.stmtmetrics.MetricEventRouter;
import com.espertech.esper.common.internal.metrics.stmtmetrics.MetricExec;
import com.espertech.esper.common.internal.metrics.stmtmetrics.MetricExecutionContext;
import com.espertech.esper.common.internal.metrics.stmtmetrics.MetricScheduleService;

public class MetricExecEngine
implements MetricExec {
    private final MetricEventRouter metricEventRouter;
    private final String runtimeURI;
    private final MetricScheduleService metricScheduleService;
    private final long interval;
    private RuntimeMetric lastMetric;

    public MetricExecEngine(MetricEventRouter metricEventRouter, String runtimeURI, MetricScheduleService metricScheduleService, long interval) {
        this.metricEventRouter = metricEventRouter;
        this.runtimeURI = runtimeURI;
        this.metricScheduleService = metricScheduleService;
        this.interval = interval;
    }

    @Override
    public void execute(MetricExecutionContext context) {
        RuntimeMetric metric;
        long inputCount = context.getFilterService().getNumEventsEvaluated();
        long schedDepth = context.getSchedulingService().getScheduleHandleCount();
        long deltaInputCount = this.lastMetric == null ? inputCount : inputCount - this.lastMetric.getInputCount();
        this.lastMetric = metric = new RuntimeMetric(this.runtimeURI, this.metricScheduleService.getCurrentTime(), inputCount, deltaInputCount, schedDepth);
        this.metricEventRouter.route(metric);
        this.metricScheduleService.add(this.interval, this);
    }

    public long getInterval() {
        return this.interval;
    }
}

