/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.metrics.stmtmetrics;

import com.espertech.esper.common.client.metric.StatementMetric;
import com.espertech.esper.common.internal.metrics.stmtmetrics.MetricEventRouter;
import com.espertech.esper.common.internal.metrics.stmtmetrics.MetricExec;
import com.espertech.esper.common.internal.metrics.stmtmetrics.MetricExecutionContext;
import com.espertech.esper.common.internal.metrics.stmtmetrics.MetricScheduleService;

public class MetricExecStatement
implements MetricExec {
    private final MetricEventRouter metricEventRouter;
    private final MetricScheduleService metricScheduleService;
    private final int statementGroup;
    private long interval;

    public MetricExecStatement(MetricEventRouter metricEventRouter, MetricScheduleService metricScheduleService, long interval, int statementGroup) {
        this.metricEventRouter = metricEventRouter;
        this.metricScheduleService = metricScheduleService;
        this.interval = interval;
        this.statementGroup = statementGroup;
    }

    @Override
    public void execute(MetricExecutionContext context) {
        long timestamp = this.metricScheduleService.getCurrentTime();
        StatementMetric[] metrics = context.getStatementMetricRepository().reportGroup(this.statementGroup);
        if (metrics != null) {
            for (int i = 0; i < metrics.length; ++i) {
                StatementMetric metric = metrics[i];
                if (metric == null) continue;
                metric.setTimestamp(timestamp);
                this.metricEventRouter.route(metrics[i]);
            }
        }
        if (this.interval != -1L) {
            this.metricScheduleService.add(this.interval, this);
        }
    }

    public void setInterval(long newInterval) {
        this.interval = newInterval;
        this.metricScheduleService.remove(this);
        if (this.interval > 0L) {
            this.metricScheduleService.add(this.interval, this);
        }
    }

    public long getInterval() {
        return this.interval;
    }
}

