/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.serde.serdeset.builtin;

import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.client.serde.EventBeanCollatedWriter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Calendar;
import java.util.TimeZone;

public class DIOCalendarSerde
implements DataInputOutputSerde<Calendar> {
    public static final DIOCalendarSerde INSTANCE = new DIOCalendarSerde();

    private DIOCalendarSerde() {
    }

    public void write(Calendar object, DataOutput output) throws IOException {
        DIOCalendarSerde.writeCalendar(object, output);
    }

    public Calendar read(DataInput input) throws IOException {
        return DIOCalendarSerde.readCalendar(input);
    }

    @Override
    public void write(Calendar object, DataOutput output, byte[] unitKey, EventBeanCollatedWriter writer) throws IOException {
        DIOCalendarSerde.writeCalendar(object, output);
    }

    @Override
    public Calendar read(DataInput input, byte[] unitKey) throws IOException {
        return DIOCalendarSerde.readCalendar(input);
    }

    public static void writeCalendar(Calendar cal, DataOutput output) throws IOException {
        if (cal == null) {
            output.writeBoolean(true);
            return;
        }
        output.writeBoolean(false);
        output.writeUTF(cal.getTimeZone().getID());
        output.writeLong(cal.getTimeInMillis());
    }

    public static Calendar readCalendar(DataInput input) throws IOException {
        boolean isNull = input.readBoolean();
        if (isNull) {
            return null;
        }
        String timeZoneId = input.readUTF();
        long millis = input.readLong();
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone(timeZoneId));
        cal.setTimeInMillis(millis);
        return cal;
    }
}

