/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.serde.serdeset.builtin;

import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.client.serde.EventBeanCollatedWriter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class DIOPrimitiveShortArray2DimNullableSerde
implements DataInputOutputSerde<short[][]> {
    public static final DIOPrimitiveShortArray2DimNullableSerde INSTANCE = new DIOPrimitiveShortArray2DimNullableSerde();

    private DIOPrimitiveShortArray2DimNullableSerde() {
    }

    @Override
    public void write(short[][] object, DataOutput output, byte[] unitKey, EventBeanCollatedWriter writer) throws IOException {
        if (object == null) {
            output.writeInt(-1);
            return;
        }
        output.writeInt(object.length);
        for (short[] i : object) {
            this.writeArray(i, output);
        }
    }

    @Override
    public short[][] read(DataInput input, byte[] unitKey) throws IOException {
        int len = input.readInt();
        if (len == -1) {
            return null;
        }
        short[][] array = new short[len][];
        for (int i = 0; i < len; ++i) {
            array[i] = this.readArray(input);
        }
        return array;
    }

    private void writeArray(short[] array, DataOutput output) throws IOException {
        if (array == null) {
            output.writeInt(-1);
            return;
        }
        output.writeInt(array.length);
        for (short i : array) {
            output.writeShort(i);
        }
    }

    private short[] readArray(DataInput input) throws IOException {
        int len = input.readInt();
        if (len == -1) {
            return null;
        }
        short[] array = new short[len];
        for (int i = 0; i < len; ++i) {
            array[i] = input.readShort();
        }
        return array;
    }
}

