/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.serde.serdeset.builtin;

import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.client.serde.EventBeanCollatedWriter;
import com.espertech.esper.common.internal.serde.serdeset.builtin.FastByteArrayInputStream;
import com.espertech.esper.common.internal.serde.serdeset.builtin.FastByteArrayOutputStream;
import com.espertech.esper.common.internal.util.ObjectInputStreamWithTCCL;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectOutputStream;

public class DIOSerializableObjectSerde
implements DataInputOutputSerde {
    public static final DIOSerializableObjectSerde INSTANCE = new DIOSerializableObjectSerde();

    private DIOSerializableObjectSerde() {
    }

    public void write(Object object, DataOutput output, byte[] pageFullKey, EventBeanCollatedWriter writer) throws IOException {
        byte[] objectBytes = DIOSerializableObjectSerde.objectToByteArr(object);
        output.writeInt(objectBytes.length);
        output.write(objectBytes);
    }

    public Object read(DataInput input, byte[] resourceKey) throws IOException {
        int size = input.readInt();
        byte[] buf = new byte[size];
        input.readFully(buf);
        return DIOSerializableObjectSerde.byteArrToObject(buf);
    }

    public static byte[] objectToByteArr(Object underlying) {
        FastByteArrayOutputStream baos = new FastByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(underlying);
            oos.close();
            baos.close();
        }
        catch (IOException e) {
            throw new RuntimeException("IO error serializing object: " + e.getMessage(), e);
        }
        return baos.getByteArrayFast();
    }

    public static Object byteArrToObject(byte[] bytes) {
        FastByteArrayInputStream bais = new FastByteArrayInputStream(bytes);
        try {
            ObjectInputStreamWithTCCL ois = new ObjectInputStreamWithTCCL(bais);
            return ois.readObject();
        }
        catch (IOException e) {
            if (e.getMessage() != null) {
                throw new RuntimeException("IO error de-serializing object: " + e.getMessage(), e);
            }
            throw new RuntimeException("IO error de-serializing object", e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class not found de-serializing object: " + e.getMessage(), e);
        }
    }

    public static void serializeTo(Object value, DataOutput output) throws IOException {
        FastByteArrayOutputStream baos = new FastByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(value);
        oos.close();
        byte[] result = baos.getByteArrayWithCopy();
        output.writeInt(result.length);
        output.write(result);
        baos.close();
    }

    public static Object deserializeFrom(DataInput input) throws IOException {
        int size = input.readInt();
        byte[] buf = new byte[size];
        input.readFully(buf);
        FastByteArrayInputStream bais = new FastByteArrayInputStream(buf);
        try {
            ObjectInputStreamWithTCCL ois = new ObjectInputStreamWithTCCL(bais);
            return ois.readObject();
        }
        catch (IOException e) {
            if (e.getMessage() != null) {
                throw new RuntimeException("IO error de-serializing object: " + e.getMessage(), e);
            }
            throw new RuntimeException("IO error de-serializing object", e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class not found de-serializing object: " + e.getMessage(), e);
        }
    }
}

