/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.serde.serdeset.builtin;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class FastByteArrayOutputStream
extends OutputStream {
    public static final int DEFAULT_INITIAL_SIZE = 100;
    public static final int DEFAULT_INCREASE_SIZE = 0;
    private byte[] bytes;
    private int length;
    private int increaseLength;
    private static final byte[] ZERO_LENGTH_BYTE_ARRAY = new byte[0];

    public FastByteArrayOutputStream(byte[] buffer) {
        this.bytes = buffer;
        this.increaseLength = 0;
    }

    public FastByteArrayOutputStream(byte[] buffer, int increase) {
        this.bytes = buffer;
        this.increaseLength = increase;
    }

    public FastByteArrayOutputStream() {
        this.bytes = new byte[100];
        this.increaseLength = 0;
    }

    public FastByteArrayOutputStream(int initialSize) {
        this.bytes = new byte[initialSize];
        this.increaseLength = 0;
    }

    public FastByteArrayOutputStream(int initialSize, int increaseSize) {
        this.bytes = new byte[initialSize];
        this.increaseLength = increaseSize;
    }

    public int size() {
        return this.length;
    }

    public void reset() {
        this.length = 0;
    }

    @Override
    public void write(int b) throws IOException {
        this.writeFast(b);
    }

    @Override
    public void write(byte[] fromBuf) throws IOException {
        this.writeFast(fromBuf);
    }

    @Override
    public void write(byte[] fromBuf, int offset, int length) throws IOException {
        this.writeFast(fromBuf, offset, length);
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.bytes, 0, this.length);
    }

    public String toString() {
        return new String(this.bytes, 0, this.length);
    }

    public String toString(String encoding) throws UnsupportedEncodingException {
        return new String(this.bytes, 0, this.length, encoding);
    }

    public byte[] getByteArrayWithCopy() {
        if (this.length == 0) {
            return ZERO_LENGTH_BYTE_ARRAY;
        }
        byte[] toBuf = new byte[this.length];
        System.arraycopy(this.bytes, 0, toBuf, 0, this.length);
        return toBuf;
    }

    public byte[] getByteArrayFast() {
        if (this.bytes.length == this.length) {
            return this.bytes;
        }
        return this.getByteArrayWithCopy();
    }

    public final void writeFast(int b) {
        if (this.length + 1 > this.bytes.length) {
            this.bump(1);
        }
        this.bytes[this.length++] = (byte)b;
    }

    public final void writeFast(byte[] fromBuf) {
        int needed = this.length + fromBuf.length - this.bytes.length;
        if (needed > 0) {
            this.bump(needed);
        }
        System.arraycopy(fromBuf, 0, this.bytes, this.length, fromBuf.length);
        this.length += fromBuf.length;
    }

    public final void writeFast(byte[] fromBuf, int offset, int length) {
        int needed = this.length + length - this.bytes.length;
        if (needed > 0) {
            this.bump(needed);
        }
        System.arraycopy(fromBuf, offset, this.bytes, this.length, length);
        this.length += length;
    }

    public byte[] getBufferBytes() {
        return this.bytes;
    }

    public int getBufferOffset() {
        return 0;
    }

    public int getBufferLength() {
        return this.length;
    }

    public void makeSpace(int sizeNeeded) {
        int needed = this.length + sizeNeeded - this.bytes.length;
        if (needed > 0) {
            this.bump(needed);
        }
    }

    public void addSize(int sizeAdded) {
        this.length += sizeAdded;
    }

    private void bump(int needed) {
        int bump = this.increaseLength > 0 ? this.increaseLength : this.bytes.length;
        byte[] toBuf = new byte[this.bytes.length + needed + bump];
        System.arraycopy(this.bytes, 0, toBuf, 0, this.length);
        this.bytes = toBuf;
    }
}

