/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.serde.serdeset.multikey;

import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.client.serde.EventBeanCollatedWriter;
import com.espertech.esper.common.internal.collection.MultiKeyArrayDouble;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class DIOMultiKeyArrayDoubleSerde
implements DataInputOutputSerde<MultiKeyArrayDouble> {
    public static final DIOMultiKeyArrayDoubleSerde INSTANCE = new DIOMultiKeyArrayDoubleSerde();

    @Override
    public void write(MultiKeyArrayDouble mk, DataOutput output, byte[] unitKey, EventBeanCollatedWriter writer) throws IOException {
        this.writeInternal(mk.getKeys(), output);
    }

    @Override
    public MultiKeyArrayDouble read(DataInput input, byte[] unitKey) throws IOException {
        return new MultiKeyArrayDouble(this.readInternal(input));
    }

    private void writeInternal(double[] object, DataOutput output) throws IOException {
        if (object == null) {
            output.writeInt(-1);
            return;
        }
        output.writeInt(object.length);
        for (double i : object) {
            output.writeDouble(i);
        }
    }

    private double[] readInternal(DataInput input) throws IOException {
        int len = input.readInt();
        if (len == -1) {
            return null;
        }
        double[] array = new double[len];
        for (int i = 0; i < len; ++i) {
            array[i] = input.readDouble();
        }
        return array;
    }
}

