/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.serde.serdeset.multikey;

import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.client.serde.EventBeanCollatedWriter;
import com.espertech.esper.common.internal.collection.MultiKeyArrayFloat;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class DIOMultiKeyArrayFloatSerde
implements DataInputOutputSerde<MultiKeyArrayFloat> {
    public static final DIOMultiKeyArrayFloatSerde INSTANCE = new DIOMultiKeyArrayFloatSerde();

    @Override
    public void write(MultiKeyArrayFloat mk, DataOutput output, byte[] unitKey, EventBeanCollatedWriter writer) throws IOException {
        this.writeInternal(mk.getKeys(), output);
    }

    @Override
    public MultiKeyArrayFloat read(DataInput input, byte[] unitKey) throws IOException {
        return new MultiKeyArrayFloat(this.readInternal(input));
    }

    private void writeInternal(float[] object, DataOutput output) throws IOException {
        if (object == null) {
            output.writeInt(-1);
            return;
        }
        output.writeInt(object.length);
        for (float i : object) {
            output.writeFloat(i);
        }
    }

    private float[] readInternal(DataInput input) throws IOException {
        int len = input.readInt();
        if (len == -1) {
            return null;
        }
        float[] array = new float[len];
        for (int i = 0; i < len; ++i) {
            array[i] = input.readFloat();
        }
        return array;
    }
}

