/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.serde.serdeset.multikey;

import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.client.serde.EventBeanCollatedWriter;
import com.espertech.esper.common.internal.collection.MultiKeyArrayLong;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class DIOMultiKeyArrayLongSerde
implements DataInputOutputSerde<MultiKeyArrayLong> {
    public static final DIOMultiKeyArrayLongSerde INSTANCE = new DIOMultiKeyArrayLongSerde();

    @Override
    public void write(MultiKeyArrayLong mk, DataOutput output, byte[] unitKey, EventBeanCollatedWriter writer) throws IOException {
        this.writeInternal(mk.getKeys(), output);
    }

    @Override
    public MultiKeyArrayLong read(DataInput input, byte[] unitKey) throws IOException {
        return new MultiKeyArrayLong(this.readInternal(input));
    }

    private void writeInternal(long[] object, DataOutput output) throws IOException {
        if (object == null) {
            output.writeInt(-1);
            return;
        }
        output.writeInt(object.length);
        for (long i : object) {
            output.writeLong(i);
        }
    }

    private long[] readInternal(DataInput input) throws IOException {
        int len = input.readInt();
        if (len == -1) {
            return null;
        }
        long[] array = new long[len];
        for (int i = 0; i < len; ++i) {
            array[i] = input.readLong();
        }
        return array;
    }
}

