/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.settings;

import com.espertech.esper.common.client.annotation.Hook;
import com.espertech.esper.common.client.annotation.HookType;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.settings.ClasspathExtensionClassEmpty;
import com.espertech.esper.common.internal.settings.ClasspathImportService;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.lang.annotation.Annotation;

public class ClasspathImportUtil {
    public static Object getAnnotationHook(Annotation[] annotations, HookType hookType, Class interfaceExpected, ClasspathImportService classpathImportService) throws ExprValidationException {
        Class clazz;
        Hook hook;
        if (annotations == null) {
            return null;
        }
        String hookClass = null;
        for (int i = 0; i < annotations.length; ++i) {
            if (!(annotations[i] instanceof Hook) || (hook = (Hook)annotations[i]).type() != hookType) continue;
            hookClass = hook.hook();
        }
        if (hookClass == null) {
            return null;
        }
        try {
            clazz = classpathImportService.resolveClass(hookClass, false, ClasspathExtensionClassEmpty.INSTANCE);
        }
        catch (Exception e) {
            throw new ExprValidationException("Failed to resolve hook provider of hook type '" + (Object)((Object)hookType) + "' import '" + hookClass + "' :" + e.getMessage());
        }
        if (!JavaClassHelper.isImplementsInterface(clazz, interfaceExpected)) {
            throw new ExprValidationException("Hook provider for hook type '" + (Object)((Object)hookType) + "' class '" + clazz.getName() + "' does not implement the required '" + interfaceExpected.getSimpleName() + "' interface");
        }
        try {
            hook = clazz.newInstance();
        }
        catch (Exception e) {
            throw new ExprValidationException("Failed to instantiate hook provider of hook type '" + (Object)((Object)hookType) + "' class '" + clazz.getName() + "' :" + e.getMessage());
        }
        return hook;
    }
}

