/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.statement.helper;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.collection.UniformPair;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerSetAssignment;
import com.espertech.esper.common.internal.compile.stage1.spec.OuterJoinDesc;
import com.espertech.esper.common.internal.compile.stage1.spec.OutputLimitRateType;
import com.espertech.esper.common.internal.compile.stage1.spec.StatementSpecRaw;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateNode;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateNodeUtil;
import com.espertech.esper.common.internal.epl.expression.core.ExprIdentNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityValidate;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContextBuilder;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.ops.ExprEqualsNodeImpl;
import com.espertech.esper.common.internal.epl.expression.subquery.ExprSubselectNode;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeIdentifierCollectVisitor;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeSubselectDeclaredDotVisitor;
import com.espertech.esper.common.internal.epl.output.condition.OutputConditionExpressionTypeUtil;
import com.espertech.esper.common.internal.epl.streamtype.StreamTypeService;
import com.espertech.esper.common.internal.epl.streamtype.StreamTypeServiceImpl;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.view.access.ViewResourceDelegateExpr;
import com.espertech.esper.common.internal.view.core.DataWindowViewForge;
import com.espertech.esper.common.internal.view.core.ViewFactoryForge;
import com.espertech.esper.common.internal.view.core.ViewForgeVisitor;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class EPStatementStartMethodHelperValidate {
    public static void validateSubqueryExcludeOuterStream(ExprNode matchCondition) throws ExprValidationException {
        ExprNodeSubselectDeclaredDotVisitor visitorSubselects = new ExprNodeSubselectDeclaredDotVisitor();
        matchCondition.accept(visitorSubselects);
        if (visitorSubselects.getSubselects().isEmpty()) {
            return;
        }
        ExprNodeIdentifierCollectVisitor visitorProps = new ExprNodeIdentifierCollectVisitor();
        for (ExprSubselectNode exprSubselectNode : visitorSubselects.getSubselects()) {
            if (exprSubselectNode.getStatementSpecCompiled().getRaw().getWhereClause() == null) continue;
            exprSubselectNode.getStatementSpecCompiled().getRaw().getWhereClause().accept(visitorProps);
        }
        for (ExprIdentNode exprIdentNode : visitorProps.getExprProperties()) {
            if (exprIdentNode.getStreamId() != 1) continue;
            throw new ExprValidationException("On-Merge not-matched filter expression may not use properties that are provided by the named window event");
        }
    }

    public static ExprNode validateExprNoAgg(ExprNodeOrigin exprNodeOrigin, ExprNode exprNode, StreamTypeService streamTypeService, String errorMsg, boolean allowTableConsumption, boolean allowTableAggReset, StatementRawInfo raw, StatementCompileTimeServices compileTimeServices) throws ExprValidationException {
        ExprValidationContext validationContext = new ExprValidationContextBuilder(streamTypeService, raw, compileTimeServices).withAllowBindingConsumption(allowTableConsumption).withAllowTableAggReset(allowTableAggReset).build();
        ExprNode validated = ExprNodeUtilityValidate.getValidatedSubtree(exprNodeOrigin, exprNode, validationContext);
        EPStatementStartMethodHelperValidate.validateNoAggregations(validated, errorMsg);
        return validated;
    }

    public static void validateNoDataWindowOnNamedWindow(List<ViewFactoryForge> forges) throws ExprValidationException {
        AtomicBoolean hasDataWindow = new AtomicBoolean();
        ViewForgeVisitor visitor = forge -> {
            if (forge instanceof DataWindowViewForge) {
                hasDataWindow.set(true);
            }
        };
        for (ViewFactoryForge forge2 : forges) {
            forge2.accept(visitor);
        }
        if (hasDataWindow.get()) {
            throw new ExprValidationException("Consuming statements to a named window cannot declare a data window view onto the named window");
        }
    }

    public static ExprNode validateNodes(StatementSpecRaw statementSpec, StreamTypeService typeService, ViewResourceDelegateExpr viewResourceDelegate, StatementRawInfo statementRawInfo, StatementCompileTimeServices compileTimeServices) throws ExprValidationException {
        String intoTableName = statementSpec.getIntoTableSpec() == null ? null : statementSpec.getIntoTableSpec().getName();
        ExprNode whereClauseValidated = null;
        if (statementSpec.getWhereClause() != null) {
            ExprNode whereClause = statementSpec.getWhereClause();
            try {
                ExprValidationContext validationContext = new ExprValidationContextBuilder(typeService, statementRawInfo, compileTimeServices).withViewResourceDelegate(viewResourceDelegate).withAllowBindingConsumption(true).withIntoTableName(intoTableName).build();
                whereClause = ExprNodeUtilityValidate.getValidatedSubtree(ExprNodeOrigin.FILTER, whereClause, validationContext);
                if (whereClause.getForge().getEvaluationType() != Boolean.TYPE && whereClause.getForge().getEvaluationType() != Boolean.class) {
                    throw new ExprValidationException("The where-clause filter expression must return a boolean value");
                }
                whereClauseValidated = whereClause;
                LinkedList<ExprAggregateNode> aggregateNodes = new LinkedList<ExprAggregateNode>();
                ExprAggregateNodeUtil.getAggregatesBottomUp(whereClause, aggregateNodes);
                if (!aggregateNodes.isEmpty()) {
                    throw new ExprValidationException("An aggregate function may not appear in a WHERE clause (use the HAVING clause)");
                }
            }
            catch (ExprValidationException ex) {
                throw new ExprValidationException("Failed to validate expression: " + ex.getMessage(), ex);
            }
        }
        if (statementSpec.getOutputLimitSpec() != null && (statementSpec.getOutputLimitSpec().getWhenExpressionNode() != null || statementSpec.getOutputLimitSpec().getAndAfterTerminateExpr() != null || statementSpec.getOutputLimitSpec().getAndAfterTerminateThenExpressions() != null)) {
            EventType outputLimitType = OutputConditionExpressionTypeUtil.getBuiltInEventType(statementRawInfo.getModuleName(), compileTimeServices.getBeanEventTypeFactoryPrivate());
            StreamTypeServiceImpl typeServiceOutputWhen = new StreamTypeServiceImpl(new EventType[]{outputLimitType}, new String[]{null}, new boolean[]{true}, false, false);
            ExprValidationContext validationContext = new ExprValidationContextBuilder(typeServiceOutputWhen, statementRawInfo, compileTimeServices).withIntoTableName(intoTableName).build();
            ExprNode outputLimitWhenNode = statementSpec.getOutputLimitSpec().getWhenExpressionNode();
            if (outputLimitWhenNode != null) {
                outputLimitWhenNode = ExprNodeUtilityValidate.getValidatedSubtree(ExprNodeOrigin.OUTPUTLIMIT, outputLimitWhenNode, validationContext);
                statementSpec.getOutputLimitSpec().setWhenExpressionNode(outputLimitWhenNode);
                if (JavaClassHelper.getBoxedType(outputLimitWhenNode.getForge().getEvaluationType()) != Boolean.class) {
                    throw new ExprValidationException("The when-trigger expression in the OUTPUT WHEN clause must return a boolean-type value");
                }
                EPStatementStartMethodHelperValidate.validateNoAggregations(outputLimitWhenNode, "An aggregate function may not appear in a OUTPUT LIMIT clause");
            }
            if (statementSpec.getOutputLimitSpec().getAndAfterTerminateExpr() != null) {
                if (statementSpec.getOutputLimitSpec().getRateType() != OutputLimitRateType.WHEN_EXPRESSION && statementSpec.getOutputLimitSpec().getRateType() != OutputLimitRateType.TERM) {
                    throw new ExprValidationException("A terminated-and expression must be used with the OUTPUT WHEN clause");
                }
                ExprNode validated = ExprNodeUtilityValidate.getValidatedSubtree(ExprNodeOrigin.OUTPUTLIMIT, statementSpec.getOutputLimitSpec().getAndAfterTerminateExpr(), validationContext);
                statementSpec.getOutputLimitSpec().setAndAfterTerminateExpr(validated);
                if (JavaClassHelper.getBoxedType(validated.getForge().getEvaluationType()) != Boolean.class) {
                    throw new ExprValidationException("The terminated-and expression must return a boolean-type value");
                }
                EPStatementStartMethodHelperValidate.validateNoAggregations(validated, "An aggregate function may not appear in a terminated-and clause");
            }
            EPStatementStartMethodHelperValidate.validateThenSetAssignments(statementSpec.getOutputLimitSpec().getThenExpressions(), validationContext, false);
            EPStatementStartMethodHelperValidate.validateThenSetAssignments(statementSpec.getOutputLimitSpec().getAndAfterTerminateThenExpressions(), validationContext, false);
        }
        for (int outerJoinCount = 0; outerJoinCount < statementSpec.getOuterJoinDescList().size(); ++outerJoinCount) {
            OuterJoinDesc outerJoinDesc = statementSpec.getOuterJoinDescList().get(outerJoinCount);
            if (outerJoinDesc.getOptLeftNode() == null) continue;
            UniformPair<Integer> streamIdPair = EPStatementStartMethodHelperValidate.validateOuterJoinPropertyPair(outerJoinDesc.getOptLeftNode(), outerJoinDesc.getOptRightNode(), outerJoinCount, typeService, viewResourceDelegate, statementRawInfo, compileTimeServices);
            if (outerJoinDesc.getAdditionalLeftNodes() == null) continue;
            HashSet<Integer> streamSet = new HashSet<Integer>();
            streamSet.add(streamIdPair.getFirst());
            streamSet.add(streamIdPair.getSecond());
            for (int i = 0; i < outerJoinDesc.getAdditionalLeftNodes().length; ++i) {
                UniformPair<Integer> streamIdPairAdd = EPStatementStartMethodHelperValidate.validateOuterJoinPropertyPair(outerJoinDesc.getAdditionalLeftNodes()[i], outerJoinDesc.getAdditionalRightNodes()[i], outerJoinCount, typeService, viewResourceDelegate, statementRawInfo, compileTimeServices);
                if (streamSet.contains(streamIdPairAdd.getFirst()) && streamSet.contains(streamIdPairAdd.getSecond())) continue;
                String message = "Outer join ON-clause columns must refer to properties of the same joined streams when using multiple columns in the on-clause";
                throw new ExprValidationException("Failed to validate outer-join expression: " + message);
            }
        }
        return whereClauseValidated;
    }

    protected static UniformPair<Integer> validateOuterJoinPropertyPair(ExprIdentNode leftNode, ExprIdentNode rightNode, int outerJoinCount, StreamTypeService typeService, ViewResourceDelegateExpr viewResourceDelegate, StatementRawInfo statementRawInfo, StatementCompileTimeServices compileTimeServices) throws ExprValidationException {
        ExprEqualsNodeImpl equalsNode = new ExprEqualsNodeImpl(false, false);
        equalsNode.addChildNode(leftNode);
        equalsNode.addChildNode(rightNode);
        try {
            ExprValidationContext validationContext = new ExprValidationContextBuilder(typeService, statementRawInfo, compileTimeServices).withViewResourceDelegate(viewResourceDelegate).withAllowBindingConsumption(true).withIsFilterExpression(true).build();
            ExprNodeUtilityValidate.getValidatedSubtree(ExprNodeOrigin.JOINON, equalsNode, validationContext);
        }
        catch (ExprValidationException ex) {
            throw new ExprValidationException("Failed to validate outer-join expression: " + ex.getMessage(), ex);
        }
        int streamIdLeft = leftNode.getStreamId();
        int streamIdRight = rightNode.getStreamId();
        if (streamIdLeft == streamIdRight) {
            String message = "Outer join ON-clause cannot refer to properties of the same stream";
            throw new ExprValidationException("Failed to validate outer-join expression: " + message);
        }
        int expectedStreamJoined = outerJoinCount + 1;
        if (streamIdLeft != expectedStreamJoined && streamIdRight != expectedStreamJoined) {
            String message = "Outer join ON-clause must refer to at least one property of the joined stream for stream " + expectedStreamJoined;
            throw new ExprValidationException("Failed to validate outer-join expression: " + message);
        }
        String badPropertyName = null;
        if (streamIdLeft > outerJoinCount + 1) {
            badPropertyName = leftNode.getResolvedPropertyName();
        }
        if (streamIdRight > outerJoinCount + 1) {
            badPropertyName = rightNode.getResolvedPropertyName();
        }
        if (badPropertyName != null) {
            String message = "Outer join ON-clause invalid scope for property '" + badPropertyName + "', expecting the current or a prior stream scope";
            throw new ExprValidationException("Failed to validate outer-join expression: " + message);
        }
        return new UniformPair<Integer>(streamIdLeft, streamIdRight);
    }

    public static void validateNoAggregations(ExprNode exprNode, String errorMsg) throws ExprValidationException {
        LinkedList<ExprAggregateNode> aggregateNodes = new LinkedList<ExprAggregateNode>();
        ExprAggregateNodeUtil.getAggregatesBottomUp(exprNode, aggregateNodes);
        if (!aggregateNodes.isEmpty()) {
            throw new ExprValidationException(errorMsg);
        }
    }

    private static void validateThenSetAssignments(List<OnTriggerSetAssignment> assignments, ExprValidationContext validationContext, boolean allowRHSAggregation) throws ExprValidationException {
        if (assignments == null || assignments.isEmpty()) {
            return;
        }
        for (OnTriggerSetAssignment assign : assignments) {
            ExprNodeUtilityValidate.validateAssignment(true, ExprNodeOrigin.UPDATEASSIGN, assign, validationContext);
        }
    }
}

