/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.type;

import com.espertech.esper.common.client.EPException;
import java.io.StringWriter;
import java.util.Locale;

public class ClassIdentifierWArray {
    public static final String PRIMITIVE_KEYWORD = "primitive";
    private final String classIdentifier;
    private final int arrayDimensions;
    private final boolean arrayOfPrimitive;

    public ClassIdentifierWArray(String classIdentifier) {
        this.classIdentifier = classIdentifier;
        this.arrayDimensions = 0;
        this.arrayOfPrimitive = false;
    }

    public ClassIdentifierWArray(String classIdentifier, int arrayDimensions, boolean arrayOfPrimitive) {
        this.classIdentifier = classIdentifier;
        this.arrayDimensions = arrayDimensions;
        this.arrayOfPrimitive = arrayOfPrimitive;
    }

    public static ClassIdentifierWArray parseSODA(String typeName) {
        int indexStart = typeName.indexOf("[");
        if (indexStart == -1) {
            return new ClassIdentifierWArray(typeName);
        }
        String name = typeName.substring(0, indexStart);
        String arrayPart = typeName.substring(indexStart).toLowerCase(Locale.ENGLISH).trim();
        arrayPart = arrayPart.replace(" ", "");
        String primitive = "[primitive]";
        if (!arrayPart.startsWith("[]") && !arrayPart.startsWith(primitive)) {
            throw new EPException("Invalid array keyword '" + arrayPart + "', expected ']' or '" + PRIMITIVE_KEYWORD + "'");
        }
        boolean arrayOfPrimitive = arrayPart.startsWith(primitive);
        if (arrayPart.equals("[]") || arrayPart.equals(primitive)) {
            return new ClassIdentifierWArray(name, 1, arrayOfPrimitive);
        }
        int dimensions = arrayPart.split("[]]", -1).length - 1;
        return new ClassIdentifierWArray(name, dimensions, arrayOfPrimitive);
    }

    public String getClassIdentifier() {
        return this.classIdentifier;
    }

    public int getArrayDimensions() {
        return this.arrayDimensions;
    }

    public boolean isArrayOfPrimitive() {
        return this.arrayOfPrimitive;
    }

    public String toEPL() {
        StringWriter writer = new StringWriter();
        this.toEPL(writer);
        return writer.toString();
    }

    public void toEPL(StringWriter writer) {
        writer.append(this.classIdentifier);
        if (this.arrayDimensions == 0) {
            return;
        }
        writer.append("[");
        if (this.arrayOfPrimitive) {
            writer.append(PRIMITIVE_KEYWORD);
        }
        writer.append("]");
        for (int i = 1; i < this.arrayDimensions; ++i) {
            writer.append("[]");
        }
    }
}

