/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.util;

import com.espertech.esper.common.internal.util.CollectionUtil;
import java.util.Comparator;

public final class ComparatorObjectArray
implements Comparator<Object[]> {
    private final boolean[] isDescendingValues;

    public ComparatorObjectArray(boolean[] isDescendingValues) {
        this.isDescendingValues = isDescendingValues;
    }

    @Override
    public final int compare(Object[] firstValues, Object[] secondValues) {
        if (firstValues.length != this.isDescendingValues.length || secondValues.length != this.isDescendingValues.length) {
            throw new IllegalArgumentException("Incompatible size MultiKey sizes for comparison");
        }
        for (int i = 0; i < firstValues.length; ++i) {
            Object valueOne = firstValues[i];
            Object valueTwo = secondValues[i];
            boolean isDescending = this.isDescendingValues[i];
            int comparisonResult = CollectionUtil.compareValues(valueOne, valueTwo, isDescending);
            if (comparisonResult == 0) continue;
            return comparisonResult;
        }
        if (!firstValues.equals(secondValues)) {
            return -1;
        }
        return 0;
    }
}

