/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.util;

import java.io.Serializable;
import java.util.Locale;

public class LikeUtil
implements Serializable {
    private static final int UNDERSCORE_CHAR = 1;
    private static final int PERCENT_CHAR = 2;
    private char[] cLike;
    private int[] wildCardType;
    private int iLen;
    private boolean isIgnoreCase;
    private int iFirstWildCard;
    private boolean isNull;
    private Character escapeChar;
    private static final long serialVersionUID = 3226305829536318662L;

    public LikeUtil(String pattern, Character escape, boolean ignorecase) {
        this.escapeChar = escape;
        this.isIgnoreCase = ignorecase;
        this.normalize(pattern);
    }

    public boolean compare(String compareString) {
        if (this.isIgnoreCase) {
            compareString = compareString.toUpperCase(Locale.ENGLISH);
        }
        return this.compareAt(compareString, 0, 0, compareString.length()) ? Boolean.TRUE : Boolean.FALSE;
    }

    public void resetPattern(String pattern) {
        this.normalize(pattern);
    }

    private boolean compareAt(String s, int i, int j, int jLen) {
        while (i < this.iLen) {
            switch (this.wildCardType[i]) {
                case 0: {
                    if (j < jLen && this.cLike[i] == s.charAt(j++)) break;
                    return false;
                }
                case 1: {
                    if (j++ < jLen) break;
                    return false;
                }
                case 2: {
                    if (++i >= this.iLen) {
                        return true;
                    }
                    while (j < jLen) {
                        if (this.cLike[i] == s.charAt(j) && this.compareAt(s, i, j, jLen)) {
                            return true;
                        }
                        ++j;
                    }
                    return false;
                }
            }
            ++i;
        }
        return j == jLen;
    }

    private void normalize(String pattern) {
        int i;
        boolean bl = this.isNull = pattern == null;
        if (!this.isNull && this.isIgnoreCase) {
            pattern = pattern.toUpperCase(Locale.ENGLISH);
        }
        this.iLen = 0;
        this.iFirstWildCard = -1;
        int l = pattern == null ? 0 : pattern.length();
        this.cLike = new char[l];
        this.wildCardType = new int[l];
        boolean bEscaping = false;
        boolean bPercent = false;
        for (i = 0; i < l; ++i) {
            char c = pattern.charAt(i);
            if (!bEscaping) {
                if (this.escapeChar != null && this.escapeChar.charValue() == c) {
                    bEscaping = true;
                    continue;
                }
                if (c == '_') {
                    this.wildCardType[this.iLen] = 1;
                    if (this.iFirstWildCard == -1) {
                        this.iFirstWildCard = this.iLen;
                    }
                } else if (c == '%') {
                    if (bPercent) continue;
                    bPercent = true;
                    this.wildCardType[this.iLen] = 2;
                    if (this.iFirstWildCard == -1) {
                        this.iFirstWildCard = this.iLen;
                    }
                } else {
                    bPercent = false;
                }
            } else {
                bPercent = false;
                bEscaping = false;
            }
            this.cLike[this.iLen++] = c;
        }
        for (i = 0; i < this.iLen - 1; ++i) {
            if (this.wildCardType[i] != 2 || this.wildCardType[i + 1] != 1) continue;
            this.wildCardType[i] = 1;
            this.wildCardType[i + 1] = 2;
        }
    }

    boolean hasWildcards() {
        return this.iFirstWildCard != -1;
    }

    boolean isEquivalentToFalsePredicate() {
        return this.isNull;
    }

    boolean isEquivalentToEqualsPredicate() {
        return this.iFirstWildCard == -1;
    }

    boolean isEquivalentToNotNullPredicate() {
        if (this.isNull || !this.hasWildcards()) {
            return false;
        }
        for (int i = 0; i < this.wildCardType.length; ++i) {
            if (this.wildCardType[i] == 2) continue;
            return false;
        }
        return true;
    }

    boolean isEquivalentToBetweenPredicate() {
        return this.iFirstWildCard > 0 && this.iFirstWildCard == this.wildCardType.length - 1 && this.cLike[this.iFirstWildCard] == '%';
    }

    boolean isEquivalentToBetweenPredicateAugmentedWithLike() {
        return this.iFirstWildCard > 0 && this.cLike[this.iFirstWildCard] == '%';
    }
}

