/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.util;

import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.util.ObjectInputStreamWithTCCL;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Base64;

public class SerializerUtil {
    public static byte[] objectToByteArr(Object underlying) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(underlying);
            oos.close();
            baos.close();
        }
        catch (IOException e) {
            throw new RuntimeException("IO error serializing object: " + e.getMessage(), e);
        }
        return baos.toByteArray();
    }

    public static Object byteArrToObject(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        try {
            ObjectInputStreamWithTCCL ois = new ObjectInputStreamWithTCCL(bais);
            return ois.readObject();
        }
        catch (IOException e) {
            if (e.getMessage() != null) {
                throw new RuntimeException("IO error de-serializing object: " + e.getMessage(), e);
            }
            throw new RuntimeException("IO error de-serializing object", e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class not found de-serializing object: " + e.getMessage(), e);
        }
    }

    public static String objectToByteArrBase64(Serializable userObject) {
        byte[] bytes = SerializerUtil.objectToByteArr(userObject);
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static Object byteArrBase64ToObject(String base64) {
        byte[] bytes = Base64.getDecoder().decode(base64);
        return SerializerUtil.byteArrToObject(bytes);
    }

    public static CodegenExpression expressionForUserObject(Object userObject) {
        if (userObject == null) {
            return CodegenExpressionBuilder.constantNull();
        }
        boolean serialize = SerializerUtil.isUseSerialize(userObject.getClass());
        if (!serialize) {
            return CodegenExpressionBuilder.constant(userObject);
        }
        String value = SerializerUtil.objectToByteArrBase64((Serializable)userObject);
        return CodegenExpressionBuilder.staticMethod(SerializerUtil.class, "byteArrBase64ToObject", CodegenExpressionBuilder.constant(value));
    }

    private static boolean isUseSerialize(Class clazz) {
        if (JavaClassHelper.isJavaBuiltinDataType(clazz)) {
            return false;
        }
        if (clazz.isArray()) {
            return SerializerUtil.isUseSerialize(clazz.getComponentType());
        }
        return true;
    }
}

