/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.derived;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.collection.SingleEventIterator;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.view.core.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.common.internal.view.core.DerivedValueView;
import com.espertech.esper.common.internal.view.core.ViewFactory;
import com.espertech.esper.common.internal.view.core.ViewForgeEnv;
import com.espertech.esper.common.internal.view.core.ViewSupport;
import com.espertech.esper.common.internal.view.derived.BaseStatisticsBean;
import com.espertech.esper.common.internal.view.derived.DerivedViewTypeUtil;
import com.espertech.esper.common.internal.view.derived.StatViewAdditionalPropsEval;
import com.espertech.esper.common.internal.view.derived.StatViewAdditionalPropsForge;
import com.espertech.esper.common.internal.view.derived.UnivariateStatisticsViewFactory;
import com.espertech.esper.common.internal.view.derived.ViewFieldEnum;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class UnivariateStatisticsView
extends ViewSupport
implements DerivedValueView {
    private final UnivariateStatisticsViewFactory viewFactory;
    protected final AgentInstanceContext agentInstanceContext;
    protected final BaseStatisticsBean baseStatisticsBean = new BaseStatisticsBean();
    private EventBean lastNewEvent;
    private EventBean[] eventsPerStream = new EventBean[1];
    protected Object[] lastValuesEventNew;

    public UnivariateStatisticsView(UnivariateStatisticsViewFactory viewFactory, AgentInstanceViewFactoryChainContext agentInstanceContext) {
        this.viewFactory = viewFactory;
        this.agentInstanceContext = agentInstanceContext.getAgentInstanceContext();
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        double point;
        Number pointnum;
        int i;
        this.agentInstanceContext.getAuditProvider().view(newData, oldData, this.agentInstanceContext, this.viewFactory);
        this.agentInstanceContext.getInstrumentationProvider().qViewProcessIRStream(this.viewFactory, newData, oldData);
        EventBean oldDataMap = null;
        if (this.lastNewEvent == null && this.child != null) {
            oldDataMap = UnivariateStatisticsView.populateMap(this.baseStatisticsBean, this.agentInstanceContext.getEventBeanTypedEventFactory(), this.viewFactory.eventType, this.viewFactory.additionalProps, this.lastValuesEventNew);
        }
        if (newData != null) {
            for (i = 0; i < newData.length; ++i) {
                this.eventsPerStream[0] = newData[i];
                pointnum = (Number)this.viewFactory.fieldEval.evaluate(this.eventsPerStream, true, this.agentInstanceContext);
                if (pointnum == null) continue;
                point = pointnum.doubleValue();
                this.baseStatisticsBean.addPoint(point, 0.0);
            }
            if (this.viewFactory.additionalProps != null && newData.length != 0) {
                if (this.lastValuesEventNew == null) {
                    this.lastValuesEventNew = new Object[this.viewFactory.additionalProps.getAdditionalEvals().length];
                }
                for (int val = 0; val < this.viewFactory.additionalProps.getAdditionalEvals().length; ++val) {
                    this.lastValuesEventNew[val] = this.viewFactory.additionalProps.getAdditionalEvals()[val].evaluate(this.eventsPerStream, true, this.agentInstanceContext);
                }
            }
        }
        if (oldData != null) {
            for (i = 0; i < oldData.length; ++i) {
                this.eventsPerStream[0] = oldData[i];
                pointnum = (Number)this.viewFactory.fieldEval.evaluate(this.eventsPerStream, true, this.agentInstanceContext);
                if (pointnum == null) continue;
                point = pointnum.doubleValue();
                this.baseStatisticsBean.removePoint(point, 0.0);
            }
        }
        if (this.child != null) {
            EventBean newDataMap = UnivariateStatisticsView.populateMap(this.baseStatisticsBean, this.agentInstanceContext.getEventBeanTypedEventFactory(), this.viewFactory.eventType, this.viewFactory.additionalProps, this.lastValuesEventNew);
            EventBean[] newEvents = new EventBean[]{newDataMap};
            EventBean[] oldEvents = this.lastNewEvent == null ? new EventBean[]{oldDataMap} : new EventBean[]{this.lastNewEvent};
            this.agentInstanceContext.getInstrumentationProvider().qViewIndicate(this.viewFactory, newEvents, oldEvents);
            this.child.update(newEvents, oldEvents);
            this.agentInstanceContext.getInstrumentationProvider().aViewIndicate();
            this.lastNewEvent = newDataMap;
        }
        this.agentInstanceContext.getInstrumentationProvider().aViewProcessIRStream();
    }

    @Override
    public final EventType getEventType() {
        return this.viewFactory.eventType;
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return new SingleEventIterator(UnivariateStatisticsView.populateMap(this.baseStatisticsBean, this.agentInstanceContext.getEventBeanTypedEventFactory(), this.viewFactory.eventType, this.viewFactory.additionalProps, this.lastValuesEventNew));
    }

    public final String toString() {
        return this.getClass().getName();
    }

    public static EventBean populateMap(BaseStatisticsBean baseStatisticsBean, EventBeanTypedEventFactory eventAdapterService, EventType eventType, StatViewAdditionalPropsEval additionalProps, Object[] lastNewValues) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(ViewFieldEnum.UNIVARIATE_STATISTICS__DATAPOINTS.getName(), baseStatisticsBean.getN());
        result.put(ViewFieldEnum.UNIVARIATE_STATISTICS__TOTAL.getName(), baseStatisticsBean.getXSum());
        result.put(ViewFieldEnum.UNIVARIATE_STATISTICS__STDDEV.getName(), baseStatisticsBean.getXStandardDeviationSample());
        result.put(ViewFieldEnum.UNIVARIATE_STATISTICS__STDDEVPA.getName(), baseStatisticsBean.getXStandardDeviationPop());
        result.put(ViewFieldEnum.UNIVARIATE_STATISTICS__VARIANCE.getName(), baseStatisticsBean.getXVariance());
        result.put(ViewFieldEnum.UNIVARIATE_STATISTICS__AVERAGE.getName(), baseStatisticsBean.getXAverage());
        if (additionalProps != null) {
            additionalProps.addProperties(result, lastNewValues);
        }
        return eventAdapterService.adapterForTypedMap(result, eventType);
    }

    public static EventType createEventType(StatViewAdditionalPropsForge additionalProps, ViewForgeEnv env, int streamNum) {
        LinkedHashMap<String, Object> eventTypeMap = new LinkedHashMap<String, Object>();
        eventTypeMap.put(ViewFieldEnum.UNIVARIATE_STATISTICS__DATAPOINTS.getName(), Long.class);
        eventTypeMap.put(ViewFieldEnum.UNIVARIATE_STATISTICS__TOTAL.getName(), Double.class);
        eventTypeMap.put(ViewFieldEnum.UNIVARIATE_STATISTICS__STDDEV.getName(), Double.class);
        eventTypeMap.put(ViewFieldEnum.UNIVARIATE_STATISTICS__STDDEVPA.getName(), Double.class);
        eventTypeMap.put(ViewFieldEnum.UNIVARIATE_STATISTICS__VARIANCE.getName(), Double.class);
        eventTypeMap.put(ViewFieldEnum.UNIVARIATE_STATISTICS__AVERAGE.getName(), Double.class);
        StatViewAdditionalPropsForge.addCheckDupProperties(eventTypeMap, additionalProps, ViewFieldEnum.UNIVARIATE_STATISTICS__DATAPOINTS, ViewFieldEnum.UNIVARIATE_STATISTICS__TOTAL, ViewFieldEnum.UNIVARIATE_STATISTICS__STDDEV, ViewFieldEnum.UNIVARIATE_STATISTICS__STDDEVPA, ViewFieldEnum.UNIVARIATE_STATISTICS__VARIANCE, ViewFieldEnum.UNIVARIATE_STATISTICS__AVERAGE);
        return DerivedViewTypeUtil.newType("statview", eventTypeMap, env, streamNum);
    }

    public BaseStatisticsBean getBaseStatisticsBean() {
        return this.baseStatisticsBean;
    }

    public Object[] getLastValuesEventNew() {
        return this.lastValuesEventNew;
    }

    public void setLastValuesEventNew(Object[] lastValuesEventNew) {
        this.lastValuesEventNew = lastValuesEventNew;
    }

    public ViewFactory getViewFactory() {
        return this.viewFactory;
    }
}

