/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.derived;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.collection.SingleEventIterator;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.event.core.MappedEventBean;
import com.espertech.esper.common.internal.view.core.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.common.internal.view.core.DerivedValueView;
import com.espertech.esper.common.internal.view.core.ViewFactory;
import com.espertech.esper.common.internal.view.core.ViewForgeEnv;
import com.espertech.esper.common.internal.view.core.ViewSupport;
import com.espertech.esper.common.internal.view.derived.DerivedViewTypeUtil;
import com.espertech.esper.common.internal.view.derived.StatViewAdditionalPropsForge;
import com.espertech.esper.common.internal.view.derived.ViewFieldEnum;
import com.espertech.esper.common.internal.view.derived.WeightedAverageViewFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class WeightedAverageView
extends ViewSupport
implements DerivedValueView {
    private final WeightedAverageViewFactory viewFactory;
    private final AgentInstanceContext agentInstanceContext;
    private EventBean[] eventsPerStream = new EventBean[1];
    protected double sumXtimesW = Double.NaN;
    protected double sumW = Double.NaN;
    protected double currentValue = Double.NaN;
    protected Object[] lastValuesEventNew;
    private EventBean lastNewEvent;

    public WeightedAverageView(WeightedAverageViewFactory viewFactory, AgentInstanceViewFactoryChainContext agentInstanceContext) {
        this.viewFactory = viewFactory;
        this.agentInstanceContext = agentInstanceContext.getAgentInstanceContext();
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        double weight;
        double point;
        Number weightnum;
        Number pointnum;
        this.agentInstanceContext.getAuditProvider().view(newData, oldData, this.agentInstanceContext, this.viewFactory);
        this.agentInstanceContext.getInstrumentationProvider().qViewProcessIRStream(this.viewFactory, newData, oldData);
        double oldValue = this.currentValue;
        MappedEventBean oldDataMap = null;
        if (this.lastNewEvent == null && this.child != null) {
            HashMap<String, Object> oldDataValues = new HashMap<String, Object>();
            oldDataValues.put(ViewFieldEnum.WEIGHTED_AVERAGE__AVERAGE.getName(), oldValue);
            this.addProperties(oldDataValues);
            oldDataMap = this.agentInstanceContext.getEventBeanTypedEventFactory().adapterForTypedMap(oldDataValues, this.viewFactory.eventType);
        }
        if (newData != null) {
            for (int i = 0; i < newData.length; ++i) {
                this.eventsPerStream[0] = newData[i];
                pointnum = (Number)this.viewFactory.fieldNameXEvaluator.evaluate(this.eventsPerStream, true, this.agentInstanceContext);
                weightnum = (Number)this.viewFactory.fieldNameWeightEvaluator.evaluate(this.eventsPerStream, true, this.agentInstanceContext);
                if (pointnum == null || weightnum == null) continue;
                point = pointnum.doubleValue();
                weight = weightnum.doubleValue();
                if (Double.valueOf(this.sumXtimesW).isNaN()) {
                    this.sumXtimesW = point * weight;
                    this.sumW = weight;
                    continue;
                }
                this.sumXtimesW += point * weight;
                this.sumW += weight;
            }
            if (this.viewFactory.additionalProps != null && newData.length != 0) {
                if (this.lastValuesEventNew == null) {
                    this.lastValuesEventNew = new Object[this.viewFactory.additionalProps.getAdditionalEvals().length];
                }
                for (int val = 0; val < this.viewFactory.additionalProps.getAdditionalEvals().length; ++val) {
                    this.lastValuesEventNew[val] = this.viewFactory.additionalProps.getAdditionalEvals()[val].evaluate(this.eventsPerStream, true, this.agentInstanceContext);
                }
            }
        }
        if (oldData != null) {
            for (int i = 0; i < oldData.length; ++i) {
                this.eventsPerStream[0] = oldData[i];
                pointnum = (Number)this.viewFactory.fieldNameXEvaluator.evaluate(this.eventsPerStream, true, this.agentInstanceContext);
                weightnum = (Number)this.viewFactory.fieldNameWeightEvaluator.evaluate(this.eventsPerStream, true, this.agentInstanceContext);
                if (pointnum == null || weightnum == null) continue;
                point = pointnum.doubleValue();
                weight = weightnum.doubleValue();
                this.sumXtimesW -= point * weight;
                this.sumW -= weight;
            }
        }
        this.currentValue = this.sumW != 0.0 ? this.sumXtimesW / this.sumW : Double.NaN;
        if (this.child != null) {
            HashMap<String, Object> newDataMap = new HashMap<String, Object>();
            newDataMap.put(ViewFieldEnum.WEIGHTED_AVERAGE__AVERAGE.getName(), this.currentValue);
            this.addProperties(newDataMap);
            MappedEventBean newDataEvent = this.agentInstanceContext.getEventBeanTypedEventFactory().adapterForTypedMap(newDataMap, this.viewFactory.eventType);
            EventBean[] newEvents = new EventBean[]{newDataEvent};
            EventBean[] oldEvents = this.lastNewEvent == null ? new EventBean[]{oldDataMap} : new EventBean[]{this.lastNewEvent};
            this.agentInstanceContext.getInstrumentationProvider().qViewIndicate(this.viewFactory, newEvents, oldEvents);
            this.child.update(newEvents, oldEvents);
            this.agentInstanceContext.getInstrumentationProvider().aViewIndicate();
            this.lastNewEvent = newDataEvent;
        }
        this.agentInstanceContext.getInstrumentationProvider().aViewProcessIRStream();
    }

    private void addProperties(Map<String, Object> newDataMap) {
        if (this.viewFactory.additionalProps == null) {
            return;
        }
        this.viewFactory.additionalProps.addProperties(newDataMap, this.lastValuesEventNew);
    }

    @Override
    public final EventType getEventType() {
        return this.viewFactory.eventType;
    }

    @Override
    public final Iterator<EventBean> iterator() {
        HashMap<String, Object> newDataMap = new HashMap<String, Object>();
        newDataMap.put(ViewFieldEnum.WEIGHTED_AVERAGE__AVERAGE.getName(), this.currentValue);
        this.addProperties(newDataMap);
        return new SingleEventIterator(this.agentInstanceContext.getEventBeanTypedEventFactory().adapterForTypedMap(newDataMap, this.viewFactory.eventType));
    }

    public static EventType createEventType(StatViewAdditionalPropsForge additionalProps, ViewForgeEnv env, int streamNum) {
        LinkedHashMap<String, Object> schemaMap = new LinkedHashMap<String, Object>();
        schemaMap.put(ViewFieldEnum.WEIGHTED_AVERAGE__AVERAGE.getName(), Double.class);
        StatViewAdditionalPropsForge.addCheckDupProperties(schemaMap, additionalProps, ViewFieldEnum.WEIGHTED_AVERAGE__AVERAGE);
        return DerivedViewTypeUtil.newType("wavgview", schemaMap, env, streamNum);
    }

    public double getSumXtimesW() {
        return this.sumXtimesW;
    }

    public void setSumXtimesW(double sumXtimesW) {
        this.sumXtimesW = sumXtimesW;
    }

    public double getSumW() {
        return this.sumW;
    }

    public void setSumW(double sumW) {
        this.sumW = sumW;
    }

    public double getCurrentValue() {
        return this.currentValue;
    }

    public void setCurrentValue(double currentValue) {
        this.currentValue = currentValue;
    }

    public Object[] getLastValuesEventNew() {
        return this.lastValuesEventNew;
    }

    public void setLastValuesEventNew(Object[] lastValuesEventNew) {
        this.lastValuesEventNew = lastValuesEventNew;
    }

    public ViewFactory getViewFactory() {
        return this.viewFactory;
    }
}

