/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.exttimedbatch;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityCodegen;
import com.espertech.esper.common.internal.epl.expression.time.eval.TimePeriodCompute;
import com.espertech.esper.common.internal.epl.expression.time.eval.TimePeriodComputeForge;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.view.core.DataWindowBatchingViewForge;
import com.espertech.esper.common.internal.view.core.DataWindowViewForge;
import com.espertech.esper.common.internal.view.core.DataWindowViewForgeWithPrevious;
import com.espertech.esper.common.internal.view.core.ViewFactoryForgeBase;
import com.espertech.esper.common.internal.view.core.ViewForgeEnv;
import com.espertech.esper.common.internal.view.core.ViewParameterException;
import com.espertech.esper.common.internal.view.exttimedbatch.ExternallyTimedBatchViewFactory;
import com.espertech.esper.common.internal.view.util.ViewFactoryTimePeriodHelper;
import com.espertech.esper.common.internal.view.util.ViewForgeSupport;
import java.util.List;

public class ExternallyTimedBatchViewForge
extends ViewFactoryForgeBase
implements DataWindowViewForge,
DataWindowViewForgeWithPrevious,
DataWindowBatchingViewForge {
    private List<ExprNode> viewParameters;
    private ExprNode timestampExpression;
    private Long optionalReferencePoint;
    private TimePeriodComputeForge timePeriodComputeForge;

    @Override
    public void setViewParameters(List<ExprNode> parameters, ViewForgeEnv viewForgeEnv, int streamNumber) throws ViewParameterException {
        this.viewParameters = parameters;
    }

    @Override
    public void attach(EventType parentEventType, int streamNumber, ViewForgeEnv viewForgeEnv) throws ViewParameterException {
        String windowName = this.getViewName();
        ExprNode[] validated = ViewForgeSupport.validate(windowName, parentEventType, this.viewParameters, true, viewForgeEnv, streamNumber);
        if (this.viewParameters.size() < 2 || this.viewParameters.size() > 3) {
            throw new ViewParameterException(this.getViewParamMessage());
        }
        if (!JavaClassHelper.isNumeric(validated[0].getForge().getEvaluationType())) {
            throw new ViewParameterException(this.getViewParamMessage());
        }
        this.timestampExpression = validated[0];
        ViewForgeSupport.assertReturnsNonConstant(windowName, validated[0], 0);
        this.timePeriodComputeForge = ViewFactoryTimePeriodHelper.validateAndEvaluateTimeDeltaFactory(this.getViewName(), this.viewParameters.get(1), this.getViewParamMessage(), 1, viewForgeEnv, streamNumber);
        if (validated.length == 3) {
            Object constant = ViewForgeSupport.validateAndEvaluate(windowName, validated[2], viewForgeEnv, streamNumber);
            if (!(constant instanceof Number) || JavaClassHelper.isFloatingPointNumber((Number)constant)) {
                throw new ViewParameterException("Externally-timed batch view requires a Long-typed reference point in msec as a third parameter");
            }
            this.optionalReferencePoint = ((Number)constant).longValue();
        }
        this.eventType = parentEventType;
    }

    @Override
    protected Class typeOfFactory() {
        return ExternallyTimedBatchViewFactory.class;
    }

    @Override
    protected String factoryMethod() {
        return "exttimebatch";
    }

    @Override
    protected void assign(CodegenMethod method, CodegenExpressionRef factory, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        method.getBlock().declareVar(TimePeriodCompute.class, "eval", this.timePeriodComputeForge.makeEvaluator(method, classScope)).exprDotMethod(factory, "setTimePeriodCompute", CodegenExpressionBuilder.ref("eval")).exprDotMethod(factory, "setOptionalReferencePoint", CodegenExpressionBuilder.constant(this.optionalReferencePoint)).exprDotMethod(factory, "setTimestampEval", ExprNodeUtilityCodegen.codegenEvaluator(this.timestampExpression.getForge(), method, this.getClass(), classScope));
    }

    @Override
    public String getViewName() {
        return "Externally-timed-batch";
    }

    private String getViewParamMessage() {
        return this.getViewName() + " view requires a timestamp expression and a numeric or time period parameter for window size and an optional long-typed reference point in msec, and an optional list of control keywords as a string parameter (please see the documentation)";
    }
}

