/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.groupwin;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.collection.IterablesListIterator;
import com.espertech.esper.common.internal.view.core.View;
import com.espertech.esper.common.internal.view.core.ViewSupport;
import com.espertech.esper.common.internal.view.groupwin.GroupByView;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class MergeView
extends ViewSupport {
    private final GroupByView groupByView;
    private final EventType eventType;
    private final Collection<View> parentViews;

    public MergeView(GroupByView groupByView, EventType eventType) {
        this.groupByView = groupByView;
        this.eventType = eventType;
        this.parentViews = new ArrayList<View>(4);
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        this.groupByView.getChild().update(newData, oldData);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public Iterator<EventBean> iterator() {
        ArrayDeque<View> iterables = new ArrayDeque<View>();
        for (View dataView : this.parentViews) {
            iterables.add(dataView);
        }
        return new IterablesListIterator(iterables.iterator());
    }

    public void removeParentView(View parentView) {
        this.parentViews.remove(parentView);
    }

    public void addParentView(View parentView) {
        this.parentViews.add(parentView);
    }
}

