/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.intersect;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.AgentInstanceMgmtCallback;
import com.espertech.esper.common.internal.context.util.AgentInstanceStopServices;
import com.espertech.esper.common.internal.view.core.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.common.internal.view.core.DataWindowView;
import com.espertech.esper.common.internal.view.core.IntersectViewMarker;
import com.espertech.esper.common.internal.view.core.View;
import com.espertech.esper.common.internal.view.core.ViewDataVisitableContainer;
import com.espertech.esper.common.internal.view.core.ViewDataVisitor;
import com.espertech.esper.common.internal.view.core.ViewDataVisitorContained;
import com.espertech.esper.common.internal.view.core.ViewFactory;
import com.espertech.esper.common.internal.view.core.ViewSupport;
import com.espertech.esper.common.internal.view.intersect.IntersectDefaultViewLocalState;
import com.espertech.esper.common.internal.view.intersect.IntersectViewFactory;
import com.espertech.esper.common.internal.view.intersect.LastPostObserver;
import com.espertech.esper.common.internal.view.intersect.LastPostObserverView;
import java.util.Iterator;
import java.util.List;

public class IntersectDefaultView
extends ViewSupport
implements LastPostObserver,
AgentInstanceMgmtCallback,
DataWindowView,
ViewDataVisitableContainer,
IntersectViewMarker {
    protected final AgentInstanceContext agentInstanceContext;
    protected final IntersectViewFactory factory;
    protected final View[] views;

    public IntersectDefaultView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext, IntersectViewFactory factory, List<View> viewList) {
        this.agentInstanceContext = agentInstanceViewFactoryContext.getAgentInstanceContext();
        this.factory = factory;
        this.views = viewList.toArray(new View[viewList.size()]);
        for (int i = 0; i < viewList.size(); ++i) {
            LastPostObserverView view = new LastPostObserverView(i);
            this.views[i].setChild(view);
            view.setObserver(this);
        }
    }

    public View[] getViewContained() {
        return this.views;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        this.agentInstanceContext.getAuditProvider().view(newData, oldData, this.agentInstanceContext, this.factory);
        this.agentInstanceContext.getInstrumentationProvider().qViewProcessIRStream(this.factory, newData, oldData);
        IntersectDefaultViewLocalState localState = this.factory.getDefaultViewLocalStatePerThread();
        if (newData != null) {
            localState.setHasRemovestreamData(false);
            localState.setIsRetainObserverEvents(true);
            try {
                for (View view : this.views) {
                    this.agentInstanceContext.getInstrumentationProvider().qViewIndicate(this.factory, newData, oldData);
                    view.update(newData, oldData);
                    this.agentInstanceContext.getInstrumentationProvider().aViewIndicate();
                }
            }
            finally {
                localState.setIsRetainObserverEvents(false);
            }
            if (localState.hasRemovestreamData()) {
                localState.getRemovalEvents().clear();
                for (int i = 0; i < localState.getOldEventsPerView().length; ++i) {
                    if (localState.getOldEventsPerView()[i] == null) continue;
                    EventBean[] viewOldData = localState.getOldEventsPerView()[i];
                    localState.getOldEventsPerView()[i] = null;
                    for (EventBean oldEvent : viewOldData) {
                        localState.getRemovalEvents().add(oldEvent);
                    }
                    localState.setIsDiscardObserverEvents(true);
                    try {
                        for (int j = 0; j < this.views.length; ++j) {
                            if (i == j) continue;
                            this.agentInstanceContext.getInstrumentationProvider().qViewIndicate(this.factory, null, viewOldData);
                            this.views[j].update(null, viewOldData);
                            this.agentInstanceContext.getInstrumentationProvider().aViewIndicate();
                        }
                        continue;
                    }
                    finally {
                        localState.setIsDiscardObserverEvents(false);
                    }
                }
                oldData = localState.getRemovalEvents().toArray(new EventBean[localState.getRemovalEvents().size()]);
            }
            this.agentInstanceContext.getInstrumentationProvider().qViewIndicate(this.factory, newData, oldData);
            this.child.update(newData, oldData);
            this.agentInstanceContext.getInstrumentationProvider().aViewIndicate();
        } else if (oldData != null) {
            localState.setIsDiscardObserverEvents(true);
            try {
                for (View view : this.views) {
                    this.agentInstanceContext.getInstrumentationProvider().qViewIndicate(this.factory, null, oldData);
                    view.update(null, oldData);
                    this.agentInstanceContext.getInstrumentationProvider().aViewIndicate();
                }
            }
            finally {
                localState.setIsDiscardObserverEvents(false);
            }
            this.agentInstanceContext.getInstrumentationProvider().qViewIndicate(this.factory, null, oldData);
            this.child.update(null, oldData);
            this.agentInstanceContext.getInstrumentationProvider().aViewIndicate();
        }
        this.agentInstanceContext.getInstrumentationProvider().aViewProcessIRStream();
    }

    @Override
    public EventType getEventType() {
        return this.factory.getEventType();
    }

    @Override
    public Iterator<EventBean> iterator() {
        return this.views[0].iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newData(int streamId, EventBean[] newEvents, EventBean[] oldEvents) {
        IntersectDefaultViewLocalState localState = this.factory.getDefaultViewLocalStatePerThread();
        if (oldEvents == null || localState.isDiscardObserverEvents()) {
            return;
        }
        if (localState.isRetainObserverEvents()) {
            localState.getOldEventsPerView()[streamId] = oldEvents;
            localState.setHasRemovestreamData(true);
            return;
        }
        localState.setIsDiscardObserverEvents(true);
        try {
            for (int i = 0; i < this.views.length; ++i) {
                if (i == streamId) continue;
                this.agentInstanceContext.getInstrumentationProvider().qViewIndicate(this.factory, null, oldEvents);
                this.views[i].update(null, oldEvents);
                this.agentInstanceContext.getInstrumentationProvider().aViewIndicate();
            }
        }
        finally {
            localState.setIsDiscardObserverEvents(false);
        }
        this.agentInstanceContext.getInstrumentationProvider().qViewIndicate(this.factory, null, oldEvents);
        this.child.update(null, oldEvents);
        this.agentInstanceContext.getInstrumentationProvider().aViewIndicate();
    }

    @Override
    public void stop(AgentInstanceStopServices services) {
        for (View view : this.views) {
            if (!(view instanceof AgentInstanceMgmtCallback)) continue;
            ((AgentInstanceMgmtCallback)((Object)view)).stop(services);
        }
    }

    @Override
    public void visitViewContainer(ViewDataVisitorContained viewDataVisitor) {
        IntersectDefaultView.visitViewContained(viewDataVisitor, this.factory, this.views);
    }

    @Override
    public void visitView(ViewDataVisitor viewDataVisitor) {
        throw new UnsupportedOperationException("Must visit container");
    }

    public static void visitViewContained(ViewDataVisitorContained viewDataVisitor, ViewFactory viewFactory, View[] views) {
        viewDataVisitor.visitPrimary(viewFactory.getViewName(), views.length);
        for (int i = 0; i < views.length; ++i) {
            viewDataVisitor.visitContained(i, views[i]);
        }
    }

    public IntersectViewFactory getViewFactory() {
        return this.factory;
    }
}

