/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.intersect;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.view.core.AsymetricDataWindowViewForge;
import com.espertech.esper.common.internal.view.core.DataWindowBatchingViewForge;
import com.espertech.esper.common.internal.view.core.DataWindowViewForge;
import com.espertech.esper.common.internal.view.core.DataWindowViewForgeUniqueCandidate;
import com.espertech.esper.common.internal.view.core.ViewFactoryForge;
import com.espertech.esper.common.internal.view.core.ViewFactoryForgeBase;
import com.espertech.esper.common.internal.view.core.ViewFactoryForgeUtil;
import com.espertech.esper.common.internal.view.core.ViewForgeEnv;
import com.espertech.esper.common.internal.view.core.ViewForgeVisitor;
import com.espertech.esper.common.internal.view.core.ViewParameterException;
import com.espertech.esper.common.internal.view.core.ViewProcessingException;
import com.espertech.esper.common.internal.view.intersect.IntersectViewFactory;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class IntersectViewFactoryForge
extends ViewFactoryForgeBase
implements DataWindowViewForge,
DataWindowViewForgeUniqueCandidate {
    protected final List<ViewFactoryForge> intersected;
    protected int batchViewIndex = -1;
    protected boolean hasAsymetric;

    public IntersectViewFactoryForge(List<ViewFactoryForge> intersected) {
        this.intersected = intersected;
        if (intersected.isEmpty()) {
            throw new IllegalStateException("Empty intersected forges");
        }
        int batchCount = 0;
        for (int i = 0; i < intersected.size(); ++i) {
            ViewFactoryForge forge = intersected.get(i);
            this.hasAsymetric |= forge instanceof AsymetricDataWindowViewForge;
            if (!(forge instanceof DataWindowBatchingViewForge)) continue;
            ++batchCount;
            this.batchViewIndex = i;
        }
        if (batchCount > 1) {
            throw new ViewProcessingException("Cannot combined multiple batch data windows into an intersection");
        }
    }

    @Override
    public void setViewParameters(List<ExprNode> parameters, ViewForgeEnv viewForgeEnv, int streamNumber) throws ViewParameterException {
    }

    @Override
    public void attach(EventType parentEventType, int streamNumber, ViewForgeEnv viewForgeEnv) throws ViewParameterException {
        this.eventType = parentEventType;
    }

    @Override
    protected Class typeOfFactory() {
        return IntersectViewFactory.class;
    }

    @Override
    protected String factoryMethod() {
        return "intersect";
    }

    @Override
    protected void assign(CodegenMethod method, CodegenExpressionRef factory, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        method.getBlock().exprDotMethod(factory, "setBatchViewIndex", CodegenExpressionBuilder.constant(this.batchViewIndex)).exprDotMethod(factory, "setHasAsymetric", CodegenExpressionBuilder.constant(this.hasAsymetric)).exprDotMethod(factory, "setIntersecteds", CodegenExpressionBuilder.localMethod(ViewFactoryForgeUtil.makeViewFactories(this.intersected, this.getClass(), method, classScope, symbols), new CodegenExpression[0]));
    }

    @Override
    public String getViewName() {
        return IntersectViewFactoryForge.getViewNameUnionIntersect(true, this.intersected);
    }

    @Override
    public void accept(ViewForgeVisitor visitor) {
        visitor.visit(this);
        for (ViewFactoryForge forge : this.intersected) {
            forge.accept(visitor);
        }
    }

    public static String getViewNameUnionIntersect(boolean intersect, Collection<ViewFactoryForge> forges) {
        StringBuilder buf = new StringBuilder();
        buf.append(intersect ? "Intersection" : "Union");
        if (forges == null) {
            return buf.toString();
        }
        buf.append(" of ");
        String delimiter = "";
        for (ViewFactoryForge forge : forges) {
            buf.append(delimiter);
            buf.append(forge.getViewName());
            delimiter = ",";
        }
        return buf.toString();
    }

    @Override
    public Set<String> getUniquenessCandidatePropertyNames() {
        for (ViewFactoryForge forge : this.intersected) {
            DataWindowViewForgeUniqueCandidate unique;
            Set<String> props;
            if (!(forge instanceof DataWindowViewForgeUniqueCandidate) || (props = (unique = (DataWindowViewForgeUniqueCandidate)((Object)forge)).getUniquenessCandidatePropertyNames()) == null) continue;
            return props;
        }
        return null;
    }

    @Override
    public List<ViewFactoryForge> getInnerForges() {
        return this.intersected;
    }
}

