/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.length;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.collection.ViewUpdatedCollection;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.view.core.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.common.internal.view.core.DataWindowView;
import com.espertech.esper.common.internal.view.core.ViewDataVisitor;
import com.espertech.esper.common.internal.view.core.ViewFactory;
import com.espertech.esper.common.internal.view.core.ViewSupport;
import com.espertech.esper.common.internal.view.length.LengthWindowViewFactory;
import java.util.ArrayDeque;
import java.util.Iterator;

public class LengthWindowView
extends ViewSupport
implements DataWindowView {
    protected final AgentInstanceContext agentInstanceContext;
    private final LengthWindowViewFactory viewFactory;
    private final int size;
    private final ViewUpdatedCollection viewUpdatedCollection;
    protected final ArrayDeque<EventBean> events = new ArrayDeque();

    public LengthWindowView(AgentInstanceViewFactoryChainContext agentInstanceContext, LengthWindowViewFactory viewFactory, int size, ViewUpdatedCollection viewUpdatedCollection) {
        if (size < 1) {
            throw new IllegalArgumentException("Illegal argument for size of length window");
        }
        this.agentInstanceContext = agentInstanceContext.getAgentInstanceContext();
        this.viewFactory = viewFactory;
        this.size = size;
        this.viewUpdatedCollection = viewUpdatedCollection;
    }

    public boolean isEmpty() {
        return this.events.isEmpty();
    }

    public final int getSize() {
        return this.size;
    }

    public ViewUpdatedCollection getViewUpdatedCollection() {
        return this.viewUpdatedCollection;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        this.agentInstanceContext.getAuditProvider().view(newData, oldData, this.agentInstanceContext, this.viewFactory);
        this.agentInstanceContext.getInstrumentationProvider().qViewProcessIRStream(this.viewFactory, newData, oldData);
        if (newData != null) {
            for (EventBean event : newData) {
                this.events.add(event);
            }
        }
        int expiredCount = this.events.size() - this.size;
        EventBean[] expiredArr = null;
        if (expiredCount > 0) {
            expiredArr = new EventBean[expiredCount];
            for (int i = 0; i < expiredCount; ++i) {
                expiredArr[i] = this.events.removeFirst();
            }
        }
        if (this.viewUpdatedCollection != null) {
            this.viewUpdatedCollection.update(newData, expiredArr);
        }
        if (this.child != null) {
            this.agentInstanceContext.getInstrumentationProvider().qViewIndicate(this.viewFactory, newData, expiredArr);
            this.child.update(newData, expiredArr);
            this.agentInstanceContext.getInstrumentationProvider().aViewIndicate();
        }
        this.agentInstanceContext.getInstrumentationProvider().aViewProcessIRStream();
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.events.iterator();
    }

    public final String toString() {
        return this.getClass().getName() + " size=" + this.size;
    }

    @Override
    public void visitView(ViewDataVisitor viewDataVisitor) {
        viewDataVisitor.visitPrimary(this.events, true, this.viewFactory.getViewName(), null);
    }

    public ViewFactory getViewFactory() {
        return this.viewFactory;
    }
}

