/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.previous;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.collection.ReversedArrayEventIterator;
import com.espertech.esper.common.internal.collection.ViewUpdatedCollection;
import com.espertech.esper.common.internal.view.access.RelativeAccessByEventNIndex;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class IStreamRelativeAccess
implements RelativeAccessByEventNIndex,
ViewUpdatedCollection {
    private final Map<EventBean, Integer> indexPerEvent;
    private EventBean[] lastNewData;
    private final IStreamRelativeAccessUpdateObserver updateObserver;

    public IStreamRelativeAccess(IStreamRelativeAccessUpdateObserver updateObserver) {
        this.updateObserver = updateObserver;
        this.indexPerEvent = new HashMap<EventBean, Integer>();
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        this.updateObserver.updated(this, newData);
        this.indexPerEvent.clear();
        this.lastNewData = newData;
        if (newData != null) {
            for (int i = 0; i < newData.length; ++i) {
                this.indexPerEvent.put(newData[i], i);
            }
        }
    }

    @Override
    public EventBean getRelativeToEvent(EventBean theEvent, int prevIndex) {
        if (this.lastNewData == null) {
            return null;
        }
        if (prevIndex == 0) {
            return theEvent;
        }
        Integer indexIncoming = this.indexPerEvent.get(theEvent);
        if (indexIncoming == null) {
            return null;
        }
        if (prevIndex > indexIncoming) {
            return null;
        }
        int relativeIndex = indexIncoming - prevIndex;
        if (relativeIndex < this.lastNewData.length && relativeIndex >= 0) {
            return this.lastNewData[relativeIndex];
        }
        return null;
    }

    @Override
    public EventBean getRelativeToEnd(int prevIndex) {
        if (this.lastNewData == null) {
            return null;
        }
        if (prevIndex < this.lastNewData.length && prevIndex >= 0) {
            return this.lastNewData[prevIndex];
        }
        return null;
    }

    @Override
    public Iterator<EventBean> getWindowToEvent() {
        return new ReversedArrayEventIterator(this.lastNewData);
    }

    @Override
    public Collection<EventBean> getWindowToEventCollReadOnly() {
        return Arrays.asList(this.lastNewData);
    }

    @Override
    public int getWindowToEventCount() {
        if (this.lastNewData == null) {
            return 0;
        }
        return this.lastNewData.length;
    }

    @Override
    public void destroy() {
    }

    @Override
    public int getNumEventsInsertBuf() {
        return this.indexPerEvent.size();
    }

    public static interface IStreamRelativeAccessUpdateObserver {
        public void updated(RelativeAccessByEventNIndex var1, EventBean[] var2);
    }
}

