/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.previous;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.collection.ArrayMaxEventCollectionRO;
import com.espertech.esper.common.internal.collection.ArrayMaxEventIterator;
import com.espertech.esper.common.internal.view.access.RandomAccessByIndex;
import com.espertech.esper.common.internal.view.access.RandomAccessByIndexObserver;
import com.espertech.esper.common.internal.view.previous.IStreamSortRankRandomAccess;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

public class IStreamSortRankRandomAccessImpl
implements RandomAccessByIndex,
IStreamSortRankRandomAccess {
    private final RandomAccessByIndexObserver updateObserver;
    private TreeMap<Object, Object> sortedEvents;
    private int currentSize;
    private Iterator<Object> iterator;
    private EventBean[] cache;
    private int cacheFilledTo;

    public IStreamSortRankRandomAccessImpl(RandomAccessByIndexObserver updateObserver) {
        this.updateObserver = updateObserver;
    }

    @Override
    public void refresh(TreeMap<Object, Object> sortedEvents, int currentSize, int maxSize) {
        this.updateObserver.updated(this);
        this.sortedEvents = sortedEvents;
        this.currentSize = currentSize;
        this.iterator = null;
        this.cacheFilledTo = 0;
        if (this.cache == null || this.cache.length < maxSize) {
            this.cache = new EventBean[maxSize];
        }
    }

    @Override
    public EventBean getNewData(int index) {
        if (this.iterator == null) {
            this.iterator = this.sortedEvents.values().iterator();
        }
        if (index >= this.currentSize) {
            return null;
        }
        if (index < this.cacheFilledTo) {
            return this.cache[index];
        }
        while (this.cacheFilledTo != this.currentSize && this.iterator.hasNext()) {
            Object entry = this.iterator.next();
            if (entry instanceof List) {
                List events = (List)entry;
                Iterator iterator = events.iterator();
                while (iterator.hasNext()) {
                    EventBean theEvent;
                    this.cache[this.cacheFilledTo] = theEvent = (EventBean)iterator.next();
                    ++this.cacheFilledTo;
                }
            } else {
                EventBean theEvent;
                this.cache[this.cacheFilledTo] = theEvent = (EventBean)entry;
                ++this.cacheFilledTo;
            }
            if (this.cacheFilledTo <= index) continue;
            break;
        }
        if (index <= this.cacheFilledTo) {
            return this.cache[index];
        }
        return null;
    }

    @Override
    public EventBean getOldData(int index) {
        return null;
    }

    @Override
    public EventBean getNewDataTail(int index) {
        this.initCache();
        if (index < this.cacheFilledTo && index >= 0) {
            return this.cache[this.cacheFilledTo - index - 1];
        }
        return null;
    }

    @Override
    public Iterator<EventBean> getWindowIterator() {
        this.initCache();
        return new ArrayMaxEventIterator(this.cache, this.cacheFilledTo);
    }

    @Override
    public Collection<EventBean> getWindowCollectionReadOnly() {
        this.initCache();
        return new ArrayMaxEventCollectionRO(this.cache, this.cacheFilledTo);
    }

    @Override
    public int getWindowCount() {
        return this.currentSize;
    }

    private void initCache() {
        if (this.iterator == null) {
            this.iterator = this.sortedEvents.values().iterator();
        }
        while (this.cacheFilledTo != this.currentSize && this.iterator.hasNext()) {
            EventBean theEvent;
            Object entry = this.iterator.next();
            if (entry instanceof List) {
                List events = (List)entry;
                Iterator iterator = events.iterator();
                while (iterator.hasNext()) {
                    EventBean theEvent2;
                    this.cache[this.cacheFilledTo] = theEvent2 = (EventBean)iterator.next();
                    ++this.cacheFilledTo;
                }
                continue;
            }
            this.cache[this.cacheFilledTo] = theEvent = (EventBean)entry;
            ++this.cacheFilledTo;
        }
    }
}

