/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.sort;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityCodegen;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.epl.expression.core.ExprOrderedExpr;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForge;
import com.espertech.esper.common.internal.view.core.DataWindowViewForge;
import com.espertech.esper.common.internal.view.core.DataWindowViewForgeWithPrevious;
import com.espertech.esper.common.internal.view.core.ViewEnum;
import com.espertech.esper.common.internal.view.core.ViewFactoryForgeBase;
import com.espertech.esper.common.internal.view.core.ViewForgeEnv;
import com.espertech.esper.common.internal.view.core.ViewParameterException;
import com.espertech.esper.common.internal.view.sort.SortWindowViewFactory;
import com.espertech.esper.common.internal.view.util.ViewForgeSupport;
import java.util.List;

public class SortWindowViewForge
extends ViewFactoryForgeBase
implements DataWindowViewForge,
DataWindowViewForgeWithPrevious {
    private List<ExprNode> viewParameters;
    private ExprForge sizeForge;
    protected ExprNode[] sortCriteriaExpressions;
    protected boolean[] isDescendingValues;
    protected DataInputOutputSerdeForge[] sortSerdes;
    private boolean useCollatorSort = false;

    @Override
    public void setViewParameters(List<ExprNode> parameters, ViewForgeEnv viewForgeEnv, int streamNumber) throws ViewParameterException {
        this.viewParameters = parameters;
        this.useCollatorSort = viewForgeEnv.getConfiguration().getCompiler().getLanguage().isSortUsingCollator();
    }

    @Override
    public void attach(EventType parentEventType, int streamNumber, ViewForgeEnv viewForgeEnv) throws ViewParameterException {
        int i;
        this.eventType = parentEventType;
        String message = this.getViewName() + " window requires a numeric size parameter and a list of expressions providing sort keys";
        if (this.viewParameters.size() < 2) {
            throw new ViewParameterException(message);
        }
        ExprNode[] validated = ViewForgeSupport.validate(this.getViewName() + " window", parentEventType, this.viewParameters, true, viewForgeEnv, streamNumber);
        for (i = 1; i < validated.length; ++i) {
            ViewForgeSupport.assertReturnsNonConstant(this.getViewName() + " window", validated[i], i);
        }
        ViewForgeSupport.validateNoProperties(this.getViewName(), validated[0], 0);
        this.sizeForge = ViewForgeSupport.validateSizeParam(this.getViewName(), validated[0], 0);
        this.sortCriteriaExpressions = new ExprNode[validated.length - 1];
        this.isDescendingValues = new boolean[this.sortCriteriaExpressions.length];
        for (i = 1; i < validated.length; ++i) {
            if (validated[i] instanceof ExprOrderedExpr) {
                this.isDescendingValues[i - 1] = ((ExprOrderedExpr)validated[i]).isDescending();
                this.sortCriteriaExpressions[i - 1] = validated[i].getChildNodes()[0];
                continue;
            }
            this.sortCriteriaExpressions[i - 1] = validated[i];
        }
        this.sortSerdes = viewForgeEnv.getSerdeResolver().serdeForDataWindowSortCriteria(ExprNodeUtilityQuery.getExprResultTypes(this.sortCriteriaExpressions), viewForgeEnv.getStatementRawInfo());
    }

    @Override
    protected Class typeOfFactory() {
        return SortWindowViewFactory.class;
    }

    @Override
    protected String factoryMethod() {
        return "sort";
    }

    @Override
    protected void assign(CodegenMethod method, CodegenExpressionRef factory, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        method.getBlock().exprDotMethod(factory, "setSize", ExprNodeUtilityCodegen.codegenEvaluator(this.sizeForge, method, this.getClass(), classScope)).exprDotMethod(factory, "setSortCriteriaEvaluators", ExprNodeUtilityCodegen.codegenEvaluators(this.sortCriteriaExpressions, (CodegenMethodScope)method, this.getClass(), classScope)).exprDotMethod(factory, "setSortCriteriaTypes", CodegenExpressionBuilder.constant(ExprNodeUtilityQuery.getExprResultTypes(this.sortCriteriaExpressions))).exprDotMethod(factory, "setIsDescendingValues", CodegenExpressionBuilder.constant(this.isDescendingValues)).exprDotMethod(factory, "setUseCollatorSort", CodegenExpressionBuilder.constant(this.useCollatorSort)).exprDotMethod(factory, "setSortSerdes", DataInputOutputSerdeForge.codegenArray(this.sortSerdes, method, classScope, null));
    }

    @Override
    public String getViewName() {
        return ViewEnum.SORT_WINDOW.getName();
    }
}

