/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.timebatch;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.time.eval.TimePeriodCompute;
import com.espertech.esper.common.internal.epl.expression.time.eval.TimePeriodComputeForge;
import com.espertech.esper.common.internal.schedule.ScheduleHandleCallbackProvider;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.view.core.DataWindowBatchingViewForge;
import com.espertech.esper.common.internal.view.core.DataWindowViewForge;
import com.espertech.esper.common.internal.view.core.DataWindowViewForgeWithPrevious;
import com.espertech.esper.common.internal.view.core.ViewFactoryForgeBase;
import com.espertech.esper.common.internal.view.core.ViewForgeEnv;
import com.espertech.esper.common.internal.view.core.ViewParameterException;
import com.espertech.esper.common.internal.view.timebatch.TimeBatchViewFactory;
import com.espertech.esper.common.internal.view.util.TimeBatchFlags;
import com.espertech.esper.common.internal.view.util.ViewFactoryTimePeriodHelper;
import com.espertech.esper.common.internal.view.util.ViewForgeSupport;
import java.util.List;

public class TimeBatchViewForge
extends ViewFactoryForgeBase
implements DataWindowViewForge,
DataWindowViewForgeWithPrevious,
ScheduleHandleCallbackProvider,
DataWindowBatchingViewForge {
    protected Long optionalReferencePoint;
    protected boolean isForceUpdate;
    protected boolean isStartEager;
    protected TimePeriodComputeForge timePeriodCompute;
    protected int scheduleCallbackId;

    @Override
    public void setViewParameters(List<ExprNode> parameters, ViewForgeEnv viewForgeEnv, int streamNumber) throws ViewParameterException {
        if (parameters.size() < 1 || parameters.size() > 3) {
            throw new ViewParameterException(this.getViewParamMessage());
        }
        Object[] viewParamValues = new Object[parameters.size()];
        for (int i = 1; i < viewParamValues.length; ++i) {
            viewParamValues[i] = ViewForgeSupport.validateAndEvaluate(this.getViewName(), parameters.get(i), viewForgeEnv, streamNumber);
        }
        this.timePeriodCompute = ViewFactoryTimePeriodHelper.validateAndEvaluateTimeDeltaFactory(this.getViewName(), parameters.get(0), this.getViewParamMessage(), 0, viewForgeEnv, streamNumber);
        TimeBatchFlags timeBatchFlags = new TimeBatchFlags(false, false);
        if (viewParamValues.length == 2 && viewParamValues[1] instanceof String) {
            timeBatchFlags = TimeBatchFlags.processKeywords(viewParamValues[1], this.getViewParamMessage());
        } else {
            if (viewParamValues.length >= 2) {
                Object paramRef = viewParamValues[1];
                if (!(paramRef instanceof Number) || JavaClassHelper.isFloatingPointNumber((Number)paramRef)) {
                    throw new ViewParameterException(this.getViewName() + " view requires a Long-typed reference point in msec as a second parameter");
                }
                this.optionalReferencePoint = ((Number)paramRef).longValue();
            }
            if (viewParamValues.length == 3) {
                timeBatchFlags = TimeBatchFlags.processKeywords(viewParamValues[2], this.getViewParamMessage());
            }
        }
        this.isForceUpdate = timeBatchFlags.isForceUpdate();
        this.isStartEager = timeBatchFlags.isStartEager();
    }

    @Override
    public void attach(EventType parentEventType, int streamNumber, ViewForgeEnv viewForgeEnv) throws ViewParameterException {
        this.eventType = parentEventType;
    }

    @Override
    protected Class typeOfFactory() {
        return TimeBatchViewFactory.class;
    }

    @Override
    protected String factoryMethod() {
        return "timebatch";
    }

    @Override
    protected void assign(CodegenMethod method, CodegenExpressionRef factory, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        if (this.scheduleCallbackId == -1) {
            throw new IllegalStateException("No schedule callback id");
        }
        method.getBlock().declareVar(TimePeriodCompute.class, "eval", this.timePeriodCompute.makeEvaluator(method, classScope)).exprDotMethod(factory, "setTimePeriodCompute", CodegenExpressionBuilder.ref("eval")).exprDotMethod(factory, "setScheduleCallbackId", CodegenExpressionBuilder.constant(this.scheduleCallbackId)).exprDotMethod(factory, "setForceUpdate", CodegenExpressionBuilder.constant(this.isForceUpdate)).exprDotMethod(factory, "setStartEager", CodegenExpressionBuilder.constant(this.isStartEager)).exprDotMethod(factory, "setOptionalReferencePoint", CodegenExpressionBuilder.constant(this.optionalReferencePoint));
    }

    private String getViewParamMessage() {
        return this.getViewName() + " view requires a single numeric or time period parameter, and an optional long-typed reference point in msec, and an optional list of control keywords as a string parameter (please see the documentation)";
    }

    @Override
    public String getViewName() {
        return "Time-Batch";
    }

    @Override
    public void setScheduleCallbackId(int scheduleCallbackId) {
        this.scheduleCallbackId = scheduleCallbackId;
    }
}

