/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.timetolive;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityCodegen;
import com.espertech.esper.common.internal.epl.expression.time.eval.TimePeriodCompute;
import com.espertech.esper.common.internal.epl.expression.time.eval.TimePeriodComputeConstGivenDeltaForge;
import com.espertech.esper.common.internal.schedule.ScheduleHandleCallbackProvider;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.view.core.DataWindowViewForge;
import com.espertech.esper.common.internal.view.core.DataWindowViewForgeWithPrevious;
import com.espertech.esper.common.internal.view.core.ViewFactoryForgeBase;
import com.espertech.esper.common.internal.view.core.ViewForgeEnv;
import com.espertech.esper.common.internal.view.core.ViewParameterException;
import com.espertech.esper.common.internal.view.timetolive.TimeOrderViewFactory;
import com.espertech.esper.common.internal.view.timetolive.TimeOrderViewForge;
import com.espertech.esper.common.internal.view.util.ViewForgeSupport;
import java.util.List;

public class TimeToLiveViewForge
extends ViewFactoryForgeBase
implements DataWindowViewForge,
DataWindowViewForgeWithPrevious,
ScheduleHandleCallbackProvider {
    private List<ExprNode> viewParameters;
    protected ExprNode timestampExpression;
    private int scheduleCallbackId = -1;

    @Override
    public void setViewParameters(List<ExprNode> parameters, ViewForgeEnv viewForgeEnv, int streamNumber) throws ViewParameterException {
        this.viewParameters = parameters;
    }

    @Override
    public void attach(EventType parentEventType, int streamNumber, ViewForgeEnv viewForgeEnv) throws ViewParameterException {
        ExprNode[] validated = ViewForgeSupport.validate(this.getViewName(), parentEventType, this.viewParameters, true, viewForgeEnv, streamNumber);
        if (this.viewParameters.size() != 1) {
            throw new ViewParameterException(this.getViewParamMessage());
        }
        if (JavaClassHelper.getBoxedType(validated[0].getForge().getEvaluationType()) != Long.class) {
            throw new ViewParameterException(this.getViewParamMessage());
        }
        this.timestampExpression = validated[0];
        this.eventType = parentEventType;
    }

    @Override
    protected Class typeOfFactory() {
        return TimeOrderViewFactory.class;
    }

    @Override
    protected String factoryMethod() {
        return "timeorder";
    }

    @Override
    protected void assign(CodegenMethod method, CodegenExpressionRef factory, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        method.getBlock().declareVar(TimePeriodCompute.class, "eval", new TimePeriodComputeConstGivenDeltaForge(0L).makeEvaluator(method, classScope)).exprDotMethod(factory, "setTimestampEval", ExprNodeUtilityCodegen.codegenEvaluator(this.timestampExpression.getForge(), method, TimeOrderViewForge.class, classScope)).exprDotMethod(factory, "setTimePeriodCompute", CodegenExpressionBuilder.ref("eval")).exprDotMethod(factory, "setScheduleCallbackId", CodegenExpressionBuilder.constant(this.scheduleCallbackId)).exprDotMethod(factory, "setTimeToLive", CodegenExpressionBuilder.constantTrue());
    }

    @Override
    public String getViewName() {
        return "Time-To-Live";
    }

    @Override
    public void setScheduleCallbackId(int id) {
        this.scheduleCallbackId = id;
    }

    private String getViewParamMessage() {
        return this.getViewName() + " view requires a single expression supplying long-type timestamp values as a parameter";
    }
}

