/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.compiler.client.option;

import com.espertech.esper.common.internal.compile.stage3.StatementBaseInfo;
import java.lang.annotation.Annotation;
import java.util.function.Supplier;

public abstract class StatementOptionContextBase {
    private final Supplier<String> eplSupplier;
    private final String statementName;
    private final String moduleName;
    private final Annotation[] annotations;
    private final int statementNumber;

    StatementOptionContextBase(StatementBaseInfo base) {
        this.eplSupplier = () -> base.getCompilable().toEPL();
        this.statementName = base.getStatementName();
        this.moduleName = base.getModuleName();
        this.annotations = base.getStatementRawInfo().getAnnotations();
        this.statementNumber = base.getStatementNumber();
    }

    public StatementOptionContextBase(Supplier<String> eplSupplier, String statementName, String moduleName, Annotation[] annotations, int statementNumber) {
        this.eplSupplier = eplSupplier;
        this.statementName = statementName;
        this.moduleName = moduleName;
        this.annotations = annotations;
        this.statementNumber = statementNumber;
    }

    public Supplier<String> getEplSupplier() {
        return this.eplSupplier;
    }

    public String getStatementName() {
        return this.statementName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public int getStatementNumber() {
        return this.statementNumber;
    }
}

