/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.compiler.internal.parse;

import com.espertech.esper.common.internal.epl.expression.chain.Chainable;
import com.espertech.esper.common.internal.epl.expression.chain.ChainableArray;
import com.espertech.esper.common.internal.epl.expression.chain.ChainableCall;
import com.espertech.esper.common.internal.epl.expression.chain.ChainableName;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.util.StringValue;
import com.espertech.esper.compiler.internal.generated.EsperEPL2GrammarParser;
import com.espertech.esper.compiler.internal.parse.ASTExprHelper;
import com.espertech.esper.compiler.internal.parse.ASTLambdaHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.tree.Tree;

public class ASTChainSpecHelper {
    public static boolean hasChain(EsperEPL2GrammarParser.ChainableElementsContext ctx) {
        return ctx != null && !ctx.chainableAtomicWithOpt().isEmpty();
    }

    public static List<Chainable> getChainables(EsperEPL2GrammarParser.ChainableContext ctx, Map<Tree, ExprNode> astExprNodeMap) {
        ArrayList<Chainable> chain = new ArrayList<Chainable>();
        EsperEPL2GrammarParser.ChainableRootWithOptContext root = ctx.chainableRootWithOpt();
        boolean optionalRoot = root.q != null;
        EsperEPL2GrammarParser.ChainableWithArgsContext prop = root.chainableWithArgs();
        chain.add(ASTChainSpecHelper.getChainable(prop, optionalRoot, astExprNodeMap));
        ASTChainSpecHelper.addChainablesInternal(ctx.chainableElements(), astExprNodeMap, chain);
        if (chain.isEmpty()) {
            throw new IllegalArgumentException("Empty chain");
        }
        return chain;
    }

    public static List<Chainable> getChainables(EsperEPL2GrammarParser.ChainableElementsContext ctx, Map<Tree, ExprNode> astExprNodeMap) {
        ArrayList<Chainable> chain = new ArrayList<Chainable>();
        ASTChainSpecHelper.addChainablesInternal(ctx, astExprNodeMap, chain);
        return chain;
    }

    public static void addChainablesInternal(EsperEPL2GrammarParser.ChainableElementsContext ctx, Map<Tree, ExprNode> astExprNodeMap, List<Chainable> chain) {
        for (EsperEPL2GrammarParser.ChainableAtomicWithOptContext context : ctx.chainableAtomicWithOpt()) {
            Chainable chainable;
            boolean optionalChainable = context.q != null;
            EsperEPL2GrammarParser.ChainableAtomicContext atomic = context.chainableAtomic();
            if (atomic.chainableArray() != null) {
                List<ExprNode> params = ASTExprHelper.exprCollectSubNodes((Tree)atomic.chainableArray(), 0, astExprNodeMap);
                chainable = new ChainableArray(false, optionalChainable, params);
            } else {
                chainable = ASTChainSpecHelper.getChainable(context.chainableAtomic().chainableWithArgs(), optionalChainable, astExprNodeMap);
            }
            chain.add(chainable);
        }
    }

    private static Chainable getChainable(EsperEPL2GrammarParser.ChainableWithArgsContext ctx, boolean optional, Map<Tree, ExprNode> astExprNodeMap) {
        boolean distinct = ctx.libFunctionArgs() != null && ctx.libFunctionArgs().DISTINCT() != null;
        String nameUnescaped = ctx.chainableIdent().getText();
        String name = StringValue.removeTicks((String)nameUnescaped);
        if (ctx.lp == null) {
            return new ChainableName(distinct, optional, name, nameUnescaped);
        }
        List<ExprNode> params = ASTLambdaHelper.getExprNodesLibFunc(ctx.libFunctionArgs(), astExprNodeMap);
        return new ChainableCall(distinct, optional, name, nameUnescaped, params);
    }
}

